% by Pavlo Bazilinskyy (p.bazilinskyy@tudelft.nl) and Joost de Winter (j.c.f.dewinter@tudelft.nl)

% QUESTIONS
% 1 Automated - Manual
% 2 Machine_like - Human-like
% 3 Mechanical - Organic
% 4 Dislike - Like
% 5 Uninteligent - Intelligent
% 6 Anxious - Relaxed

% CONDITIONS
% 1	Playback manual
% 2	Stereotype automated 'road centre tendency'
% 3	Stereotype automated 'lane centre tendency'
% 4	Stereotype human 'normal'
% 5	Stereotype human 'safe'
% 6	Manual deceleration
% 7	Stereotype automated 'fixed deceleration'
% 8	Stereotype manual 'sudden stop'
% 9	Stereotype manual 'crawling forward'

clear all;close all;clc %#ok<CLALL>
%% Import data from questionnaires
alpha=0.01; % Alpha value used for significance testing
raw_questionnaire = readtable('data.xlsx');           % Import Excel file with responses to questionnaires
comments          = readtable('comments.xlsx');       % Import Excel file with comments
raw_questionnaire = raw_questionnaire(1:24,:); % 24 participants
trials_mapping    = readtable('trials_mapping.xlsx'); % Import Excel file with mapping data
trials_mapping    = trials_mapping(1:4,:);
trials = raw_questionnaire;  % mapped answers to questions

for i=1:24 % Loop over participants
    trial_number = 1;
    session_id = raw_questionnaire{i,2};
    found_once=zeros(1,9);
    for j=9:7:size(raw_questionnaire, 2)
        trial_found = table2cell(trials_mapping(raw_questionnaire{i,2}, trial_number+1));
        trial_found = cell2mat(trial_found);
        if ischar(trial_found)
            trial_found=str2double(trial_found);
        end
        if found_once(trial_found)== 0
            trials(i,9+(trial_found-1)*14:15+(trial_found-1)*14) = raw_questionnaire(i,j:j+6);
            found_once(trial_found) = 1;
        else
            trials(i,16+(trial_found-1)*14:22+(trial_found-1)*14) = raw_questionnaire(i,j:j+6);
        end
        trial_number = trial_number + 1;
    end
end
%% Comments mapped
[Comment_ordered1,Comment_ordered2]=deal(cell(24,9));
Comment_ordered_nr=zeros(24,9);
V=3:2:size(comments,2); % Every two columns is the English translation
for i=1:24 % loop over participants
    for j=1:18
        trial_found = table2cell(trials_mapping(raw_questionnaire{i,2}, j+1));
        trial_found = cell2mat(trial_found);
        if ischar(trial_found)
            trial_found=str2double(trial_found);
        end
        comment=comments(i,V(j));
        if  Comment_ordered_nr(i,trial_found)==0
            Comment_ordered1(i,trial_found)=table2cell(comment);
        elseif Comment_ordered_nr(i,trial_found)==1
            Comment_ordered2(i,trial_found)=table2cell(comment);
        end
        Comment_ordered_nr(i,trial_found)=Comment_ordered_nr(i,trial_found)+1; % number of comments for that condition
    end
end
%% Group questionnaire data in AllQ matrix. The two responses for the two repititions are averaged
I=[9 11 12 13 14 15]; % column indexes
[AllQ,AllQ1,AllQ2]=deal(NaN(24,6,9));  % 24 participants x 6 questions x 9 conditions

for i=1:length(I) % loop over the six questions
    for i2=0:2:16 % loop over the 9 experimental conditions
        AllQ(:,i,(i2/2+1))=mean([trials{:,I(i)+7*i2} trials{:,I(i)+7*(i2+1)}],2); % average of the two trials
        AllQ1(:,i,(i2/2+1))=trials{:,I(i)+7*i2};  % first trial
        AllQ2(:,i,(i2/2+1))=trials{:,I(i)+7*(i2+1)};  % second trial
    end
end
AllQ(:,1,:)=6-AllQ(:,1,:); % Question 1 was asked on a scale from 1 = manual driving to 5 = automated driving. Here, it is reversed to 1 = automated driving, 5 = manual driving
AllQ1(:,1,:)=6-AllQ1(:,1,:); % Question 1 was asked on a scale from 1 = manual driving to 5 = automated driving. Here, it is reversed to 1 = automated driving, 5 = manual driving
AllQ2(:,1,:)=6-AllQ2(:,1,:); % Question 1 was asked on a scale from 1 = manual driving to 5 = automated driving. Here, it is reversed to 1 = automated driving, 5 = manual driving

disp('Means of participants')
disp(round(squeeze(nanmean(AllQ)),2)')

disp('SDs of participants')
disp(round(squeeze(std(AllQ)),2)')

%% Bar graph for trajectory conditions
SE=squeeze(std(AllQ(:,:,1:5)))./sqrt(size(AllQ,1)); % standard errors (6 questions x 5 conditions)
figure;
b=bar(squeeze(nanmean(AllQ(:,:,1:5))));hold on
xticklabels({'Automated (1) - Manual (5)', 'Machine-like (1) - Human-like (5)', 'Mechanical (1) - Organic (5)', 'Dislike (1) - Like (5)', 'Unintelligent (1) - Intelligent (5)', 'Anxious (1) - Relaxed (5)'});
legend('Playback manual (M)', 'Stereotype automated ''road centre tendency'' (R)', 'Stereotype automated ''lane centre tendency'' (L)', 'Stereotype human ''normal'' (N)', 'Stereotype human ''safe'' (S)','location','northoutside')
xtickangle(45);
set(gca, 'LooseInset', [0.01 0.01 0.01 0.01],'ylim',[1 7]);
grid on

[ctr,ydt]=deal(NaN(5,6));
%stats_t=NaN(6,5,5);
pvalues_t=NaN(6,5,5);
cohensd_t=NaN(6,5,5);
for k1 = 1:5 % retrieve coordinates for plotting text above bars
    ctr(k1,:) = bsxfun(@plus, b(k1).XData, [b(k1).XOffset]');
    ydt(k1,:) = b(k1).YData;
end
errorbar(ctr, ydt, SE', '.k','handlevisibility','off','Linewidth',2)
h = findobj('FontName','Helvetica'); set(h,'FontSize',20,'Fontname','Arial')

% calculate pvalues between pairs of conditions
for i=1:6 % 6 questions
    data_for_question=squeeze(AllQ(:,i,1:5));
    for condition1=1:5
        for condition2=1:5
            [~,pvalues_t(i,condition1,condition2),~,stats_t(i,condition1,condition2)]=ttest(data_for_question(:,condition1),data_for_question(:,condition2));
            cohensd_t(i,condition1,condition2)=cohend(data_for_question(:,condition1),data_for_question(:,condition2));  % or 'paired'?
        end
    end
end

for i=1:6 % 6 questions
    for condition=1:5
        text(ctr(condition,i),4.6,sprintf('%0.2f',mean(AllQ(:,i,condition))),'horizontalalignment','center','fontsize',12)
        text(ctr(condition,i),4.4,['(' sprintf('%0.2f',std(AllQ(:,i,condition))) ')'],'horizontalalignment','center','fontsize',12)      
        pvalues_for_text=squeeze(pvalues_t(i,condition,:));
        string=[];
        if pvalues_for_text(1)<alpha;string=[string 'M'];end %#ok<AGROW>
        if pvalues_for_text(2)<alpha;string=[string 'R'];end %#ok<AGROW>
        if pvalues_for_text(3)<alpha;string=[string 'L'];end %#ok<AGROW>
        if pvalues_for_text(4)<alpha;string=[string 'N'];end %#ok<AGROW>
        if pvalues_for_text(5)<alpha;string=[string 'S'];end %#ok<AGROW>
        
        if ~isempty(string)
            text(ctr(condition,i),ydt(condition,i)+SE(i,condition)+0.17,string,'horizontalalignment','center','fontsize',16)
        end
        if condition==1
            text(ctr(condition,i),1.5,'M','horizontalalignment','center','fontsize',16,'color','w')
        elseif condition ==2
            text(ctr(condition,i),1.5,'R','horizontalalignment','center','fontsize',16,'color','w')
        elseif condition ==3
            text(ctr(condition,i),1.5,'L','horizontalalignment','center','fontsize',16,'color','w')
        elseif condition ==4
            text(ctr(condition,i),1.5,'N','horizontalalignment','center','fontsize',16,'color','w')
        elseif condition ==5
            text(ctr(condition,i),1.5,'S','horizontalalignment','center','fontsize',16,'color','w')
        end
    end
end
%% Bar graph for deceleration conditions
SE=squeeze(std(AllQ(:,:,6:9)))./sqrt(size(AllQ,1)); % standard errors (6 questions x 4 conditions)

figure
b=bar(squeeze(nanmean(AllQ(:,:,6:9))));hold on
xticklabels({'Automated (1) - Manual (5)', 'Machine-like (1) - Human-like (5)', 'Mechanical (1) - Organic (5)', 'Dislike (1) - Like (5)', 'Unintelligent (1) - Intelligent (5)', 'Anxious (1) - Relaxed (5)'});
legend('Manual (M)', 'Stereotype automated ''fixed deceleration'' (F)', 'Stereotype manual ''sudden stop'' (S)', 'Stereotype manual ''crawling forward'' (C)','location','northoutside')
xtickangle(45);
set(gca, 'LooseInset', [0.01 0.01 0.01 0.01],'ylim',[1 5]);
[ctr,ydt]=deal(NaN(4,6));
grid on

for k1 = 1:4 % retrieve coordinates for plotting text above bars
    ctr(k1,:) = bsxfun(@plus, b(k1).XData, [b(k1).XOffset]');
    ydt(k1,:) = b(k1).YData;
end
errorbar(ctr, ydt, SE', '.k','handlevisibility','off','Linewidth',2)
h = findobj('FontName','Helvetica'); set(h,'FontSize',20,'Fontname','Arial')

% stats_d=NaN(6,4,4);
pvalues_d=NaN(6,4,4);
cohensd_d=NaN(6,4,4);
for i=1:6 % 6 questions
    data_for_question=squeeze(AllQ(:,i,6:9));
    for condition1=1:4
        for condition2=1:4
            [~,pvalues_d(i,condition1,condition2),~,stats_d(i,condition1,condition2)]=ttest(data_for_question(:,condition1),data_for_question(:,condition2));
            cohensd_d(i,condition1,condition2)=cohend(data_for_question(:,condition1),data_for_question(:,condition2));
        end
    end
end

for i=1:6 % 6 questions
    for condition=1:4
        text(ctr(condition,i),4.6,sprintf('%0.2f',mean(AllQ(:,i,5+condition))),'horizontalalignment','center','fontsize',12)
        text(ctr(condition,i),4.4,['(' sprintf('%0.2f',std(AllQ(:,i,5+condition))) ')'],'horizontalalignment','center','fontsize',12)
        pvalues_for_text=squeeze(pvalues_d(i,condition,:));
        string=[];
        if pvalues_for_text(1)<alpha;string=[string 'M'];end %#ok<AGROW>
        if pvalues_for_text(2)<alpha;string=[string 'F'];end %#ok<AGROW>
        if pvalues_for_text(3)<alpha;string=[string 'S'];end %#ok<AGROW>
        if pvalues_for_text(4)<alpha;string=[string 'C'];end %#ok<AGROW>
        if ~isempty(string)
            text(ctr(condition,i),ydt(condition,i)+SE(i,condition)+0.17,string,'horizontalalignment','center','fontsize',16)
        end
        if condition==1
            text(ctr(condition,i),1.5,'M','horizontalalignment','center','fontsize',16,'color','w')
        elseif condition ==2
            text(ctr(condition,i),1.5,'F','horizontalalignment','center','fontsize',16,'color','w')
        elseif condition ==3
            text(ctr(condition,i),1.5,'S','horizontalalignment','center','fontsize',16,'color','w')
        elseif condition ==4
            text(ctr(condition,i),1.5,'C','horizontalalignment','center','fontsize',16,'color','w')
        end
    end
end
%% Correlation matrix
round(corr(squeeze(mean(squeeze(AllQ(:,1:6,1:9)),3))),2)
%% Statistics
disp(['Number of participants = ' num2str(size(raw_questionnaire, 1))])
disp(['Gender, male respondents = ' num2str(sum(raw_questionnaire{:,3}==1))])
disp(['Gender, female respondents = ' num2str(sum(raw_questionnaire{:,3}==2))])
disp(['Age, mean = ' num2str(nanmean(raw_questionnaire{:,4}))])
disp(['Age, sd = ' num2str(nanstd(raw_questionnaire{:,4}))])

disp(['Frequency of driving, every day = ' num2str(sum(raw_questionnaire{:,7}==1))])
disp(['Frequency of driving, 4 to 6 days a week = ' num2str(sum(raw_questionnaire{:,7}==2))])
disp(['Frequency of driving, 1 to 3 days a week = ' num2str(sum(raw_questionnaire{:,7}==3))])
disp(['Frequency of driving, Once a month to once a week = ' num2str(sum(raw_questionnaire{:,7}==4))])
disp(['Frequency of driving, Less than once a month = ' num2str(sum(raw_questionnaire{:,7}==5))])
disp(['Frequency of driving, Never = ' num2str(sum(raw_questionnaire{:,7}==6))])
disp(['Frequency of driving, I prefer not to respoond = ' num2str(sum(raw_questionnaire{:,7}==7))])

disp(['Mode of transport, private vehicle = ' num2str(sum(raw_questionnaire{:,5}==1))])
disp(['Mode of transport, public transport = ' num2str(sum(raw_questionnaire{:,5}==2))])
disp(['Mode of transport, motorcycle = ' num2str(sum(raw_questionnaire{:,5}==3))])
disp(['Mode of transport, walking/cycling = ' num2str(sum(raw_questionnaire{:,5}==4))])
disp(['Mode of transport, other = ' num2str(sum(raw_questionnaire{:,5}==5))])

disp(['Mileage, 0 km = ' num2str(sum(raw_questionnaire{:,8}==1))])
disp(['Mileage, 1-1000 km = ' num2str(sum(raw_questionnaire{:,8}==2))])
disp(['Mileage, 1001-5000 km = ' num2str(sum(raw_questionnaire{:,8}==3))])
disp(['Mileage, 5001-15000 km = ' num2str(sum(raw_questionnaire{:,8}==4))])
disp(['Mileage, 15001 - 20000 km = ' num2str(sum(raw_questionnaire{:,8}==5))])
disp(['Mileage, 20001 - 25000 km = ' num2str(sum(raw_questionnaire{:,8}==6))])
disp(['Mileage, 25001 - 35000 km = ' num2str(sum(raw_questionnaire{:,8}==7))])
disp(['Mileage, 35001 - 50000 km = ' num2str(sum(raw_questionnaire{:,8}==8))])
disp(['Mileage, 50001 - 100000 km = ' num2str(sum(raw_questionnaire{:,8}==9))])
disp(['Mileage, More than 100000 km = ' num2str(sum(raw_questionnaire{:,8}==10))])
disp(['Mileage, I prefer not to respond = ' num2str(sum(raw_questionnaire{:,8}==11))])

%% Tables with stats
% define names of conditions
conditions_t = {'Playback manual' ...
                'Stereotype automated ''road centre tendency''' ...
                'Stereotype automated ''lane centre tendency''' ...
                'Stereotype human ''normal''' ...
                'Stereotype human ''safe'''};
conditions_d = {'Manual deceleration' ...
                'Stereotype automated ''fixed deceleration''' ...
                'Stereotype manual ''sudden stop''' ...
                'Stereotype manual ''crawling forward'''};
questions = {'Automated/Manual' ...
             'Machine-like/Human-like' ...
             'Mechanical/Organic' ...
             'Dislike/Like' ...
             'Unintelligent/Intelligent' ...
             'Anxious/Relaxed'};
var_types_t = ["string", "string", "string", "string", "string"];
var_types_d = ["string", "string", "string", "string"];
% build rows
conditions_questions_t = {};
row_id = 1;  % index of processed row
for question=1:size(questions,2)
    for condition=1:size(conditions_t, 2)
        conditions_questions_t(row_id) = strcat(questions(question), {' :: '}, conditions_t(condition));
        row_id = row_id + 1;
    end
end
conditions_questions_d = {};
row_id = 1;  % index of processed row
for question=1:size(questions,2)
    for condition=1:size(conditions_d, 2)
        conditions_questions_d(row_id) = strcat(questions(question), {' :: '}, conditions_d(condition));
        row_id = row_id + 1;
    end
end

% table for trajectory trials
stats_table_t = table('Size', [size(conditions_questions_t,2), size(conditions_t,2)], ...
                      'VariableTypes', var_types_t);
stats_table_t.Properties.RowNames = conditions_questions_t;
stats_table_t.Properties.VariableNames = conditions_t;

row_id = 1;  % index of processed row
for question=1:1:size(questions, 2) % questions
    for condition1=1:size(conditions_t, 2) % conditions - 1
        for condition2=1:1:size(conditions_t, 2) % conditions - 2
            stats = stats_t(question, condition1, condition2);
            pvalue = pvalues_t(question, condition1, condition2);
            if pvalue < 0.001
                pvalue = 'p < 0.001';
            else
                pvalue = ['p = ' sprintf('%0.3f', pvalue)];
            end
            % check for nan cells
            if isnan(stats.tstat)
                value = '------------------------------------------------------------';
            else
                value = ['t(' num2str(stats.df) ') = ' sprintf('%0.2f', stats.tstat) ...
                         ', ' pvalue ...
                         ', d = ' sprintf('%0.2f', cohensd_t(question, condition1, condition2)) ...
                         ', dz = ' sprintf('%0.2f', stats.tstat./sqrt(stats.df+1))];
            end
            stats_table_t(row_id, condition2) = {value};
        end
        row_id = row_id + 1;
    end
end

% table for deceleration trials
stats_table_d = table('Size', [size(conditions_questions_d,2), size(conditions_d,2)], ...
                      'VariableTypes', var_types_d);
stats_table_d.Properties.RowNames = conditions_questions_d;
stats_table_d.Properties.VariableNames = conditions_d;

row_id = 1;  % index of processed row
for question=1:1:size(questions, 2) % questions
    for condition1=1:size(conditions_d, 2) % conditions - 1
        for condition2=1:1:size(conditions_d, 2) % conditions - 2
            stats = stats_d(question, condition1, condition2);
            pvalue = pvalues_d(question, condition1, condition2);
            if pvalue < 0.001
                pvalue = 'p < 0.001';
            else
                pvalue = ['p = ' sprintf('%0.3f', pvalue)];
            end
            % check for nan cells
            if isnan(stats.tstat)
                value = '------------------------------------------------------------';
            else
                value = ['t(' num2str(stats.df) ') = ' sprintf('%0.2f', stats.tstat) ...
                         ', ' pvalue ...
                         ', d = ' sprintf('%0.2f', cohensd_d(question, condition1, condition2)) ...
                         ', d_z = ' sprintf('%0.2f', stats.tstat./sqrt(stats.df+1))];
            end
            stats_table_d(row_id, condition2) = {value};
        end
        row_id = row_id + 1;
    end
end

% export to xlsx
writetable(stats_table_t, 'stats_trajectory.xlsx', 'WriteRowNames', true);
writetable(stats_table_d, 'stats_deceleration.xlsx', 'WriteRowNames', true);

%%
participant = 1;
disp(['Example comments for participant' num2str(participant)])
for i=participant
    temp1=find(AllQ1(:,1,i)>=4); % 1 = automated, 5 = manual
    temp2=find(AllQ2(:,1,i)>=4); % 1 = automated, 5 = manual
    disp(['Manual (4 or 5), no of participants = ' num2str(length(temp1)+length(temp2))])
    disp(Comment_ordered1(temp1,i))
    disp(Comment_ordered2(temp2,i))

    temp3=find(AllQ1(:,1,i)==3); % 1 = automated, 5 = manual
    temp4=find(AllQ2(:,1,i)==3); % 1 = automated, 5 = manual
    disp(['Undecided (3), no of participants = ' num2str(length(temp3)+length(temp4))])
    disp(Comment_ordered1(temp3,i))
    disp(Comment_ordered2(temp4,i))
    
    temp3=find(AllQ1(:,1,i)<=2); % 1 = automated, 5 = manual
    temp4=find(AllQ2(:,1,i)<=2); % 1 = automated, 5 = manual
    disp(['Automated (1 or 2), no of participants = ' num2str(length(temp3)+length(temp4))])
    disp(Comment_ordered1(temp3,i))
    disp(Comment_ordered2(temp4,i))
end

function cd = cohend(X1,X2)
X1=X1(~isnan(X1));
X2=X2(~isnan(X2));
M1=mean(X1);
M2=mean(X2);
n1=length(X1);
n2=length(X2);
SDpooled= sqrt((std(X1)^2*(n1-1)+std(X2)^2*(n2-1))/(n1+n2-2));
cd=(M1-M2)/SDpooled;
end