import numpy as np

from model_cpwresonator import fun_k, cpw_ind_total, cpw_cap_total

def ind_nbtin_cpw(width, spacing, length, freq0):
    '''Returns kinetic sheet inductance per square for a quarter-wavelength transmission line resonator
    with given geometry (width, spacing, length) and measured resonance frequency (freq0).
    Wraps around functions from model_cpwresonator.'''
    ind_kin_sq = 0
    k = fun_k(width, spacing)
    cap_m = cpw_cap_total(k, epsilon_r=11.7)
    ind_m = cpw_ind_total(k, ind_kin_sq, width)

    ind_kin_sq_calc = width * (1 / (16 * length**2 * freq0**2 * cap_m) - ind_m)

    return ind_kin_sq_calc

def ind_nw_cpw(freqnw, freq0, imp0):
    '''Returns nanowire inductance for given resonator properties (freq0, imp0)
    and measured resonance frequency of nanowire resonator. Based on Eq. 9 in Supplement. '''
    return np.pi / 2 * imp0 * (1 - freqnw / freq0) / (2 * np.pi * freqnw)


def res_nw_cpw(q_i, q_ref, imp0):
    '''Returns nanowire resistance for given resonator properties (imp0, q_ref)
    and measured internal quality factor of nanowire resonator. Based on Eq. 9 in Supplement. '''
    return np.pi * imp0 / 4 * (1 / q_i - 1 / q_ref)
