# -*- coding: utf-8 -*-
"""
Created on Tue Mar  1 13:59:35 2022

@author: francescvarkev
"""
import pandas as pd
import numpy as np
# from WaveformModule import waveform
import matplotlib.pyplot as plt
# from scipy.integrate import simps
from analysisfunctions_DF import eSave_const_box, eSave_adaptive_box

df = pd.read_pickle('DataFilesFinal/DataFrame_all.pkl') 
df.loc[df['ex'] == 0, ['th', 'e', 'q']] = np.nan # if ex == 0, set th, e and q tot nan
df['E_const'] = df['q']*df['th']

# tmp = df.iloc[3000]
# wave, t = waveform(c = tmp.dur, c0=0, hc=tmp.th, w=tmp['shape'], dt=tmp['dt'])
# plt.plot(t, wave)

# df.query('cell_id == 20 & loc == "(-300, -900, 300)"').set_index('dur').groupby('shape')['e'].plot()


#%% Remove incorrect data

tmp = df.loc[df.groupby(['cell_id', 'loc', 'shape'], observed=True)['e'].idxmin().dropna()]['dur'] # series of min e
tmp = df.iloc[tmp[tmp > 1.45].index.astype('int')] # series of index where opt dur is bigger than 1.4
tmp['cellloc'] = tmp['cell_id'].astype('str') + tmp['loc'].astype('str')
df2 = df
for i in tmp['cellloc'].unique():
    cell = i[0:2]
    loc = i[2:]
    df2 = df2.drop(df2.query(f'cell_id == {cell} & loc == "{loc}"').index)
    
#%%
 
fig1, ax1, Eadapive_old = eSave_adaptive_box(df)
ax1.axhline(color = 'r', linewidth=0.5)

fig2, ax2, Eadaptive_new = eSave_adaptive_box(df2)
ax2.axhline(color='r', linewidth=0.5)
ax2.set_ylabel('$E_x$/$E_r$ - 1', size=18)
fig2.suptitle('')
ax2.set_xticklabels(['Gaussian', 'Sine', 'Triangular', 'Ramp-Up', 'Ramp-Down'], fontsize=18, rotation=45, ha='center')
ax2.tick_params(labelsize=16)
fig2.tight_layout()
fig2.savefig('Figures/Esave_adaptive.eps')


fig3, ax3, Econst_old = eSave_const_box(df)
ax3.axhline(color='r', linewidth=0.5)

fig4, ax4, Econst_new = eSave_const_box(df2)
ax4.axhline(color='r', linewidth=0.5)
ax4.set_ylabel('$E_x$/$E_r$ - 1', size=18)
fig4.suptitle('')
ax4.set_xticklabels(['Gaussian', 'Sine', 'Triangular', 'Ramp-Up', 'Ramp-Down'], fontsize=18, rotation=45, ha='center')
ax4.tick_params(labelsize=16)
fig4.tight_layout()
fig4.savefig('Figures/Esave_const.eps')
