# -*- coding: utf-8 -*-
"""
Created on Fri Oct  8 16:11:32 2021

@author: francescvarkev
"""

from multiprocessing import Pool
from functools import partial
from config import setMeta
from time import time
from simulationfunctions import run_and_save_parallel_locSweep
from model import initCell, quitNeuron
import os
import pickle
import sys

def f(loc, cell_id, meta):
    run_and_save_parallel_locSweep(loc, cell_id, meta)


def loc(loc):
    return loc

if __name__ == '__main__':
    tic = time()
    cell_id = sys.argv[1]
    print(cell_id)
    config='detailed_finalset'
    initCell(cell_id)
    meta = setMeta(config, cell_id)
    loclist = meta['loclist']
    os.mkdir('DatafilesFinal/' + str(cell_id))
    text_file = open("DatafilesFinal/" + str(cell_id) + '/elapsedtime.txt', "w")
    text_file.write(str(len(loclist)))
    text_file.write("\n")
    text_file.close()
    
    a_file = open("DatafilesFinal/" + str(cell_id) + '/meta.pkl', "wb")
    pickle.dump(meta, a_file)
    a_file.close() 
    
    with Pool(35) as p:
        p.map(partial(f, cell_id=cell_id, meta=meta), loclist)
        # print(p.map(loc, loclist))

    
    elapsed_time = (time() - tic)/3600
    text_file = open("DatafilesFinal/" + str(cell_id) + '/elapsedtime.txt', "a")
    text_file.write(str(elapsed_time))
    text_file.close()
    quitNeuron()
