# -*- coding: utf-8 -*-
"""
Created on Tue Jul  6 16:30:34 2021

@author: francescvarkev
"""
# This file stores different standard configurations
# By Koen Emmer
from datetime import date
from neuron import h
import numpy as np

def selectConfig(config):
    # STANDARDIZED PARAMETERS
    par = {
        # Default parameters for human adult
        # ENVIRONMENTAL PARAMETERS
        
        'myelinate_ax'      :   1,       # myelinate axon by default
        'scale_axon_diam'   :   2.453,
        'scale_apic_diam'   :   1.876,   # Romand 2011 L5 PC
        'scale_basal_diam'  :   1.946,   # Romand 2011 
        'scale_soma_area'   :   2.453,   # Zhu 2000
        'scale_basal_L'     :   1.17 ,   # Romand 2011
        'min_myelinD'       :   0.2  ,   # Waxman 1970
        'max_myelin_order'  :   0    ,   
        'celsius'           :   37.0 ,   # Temperature
        
        
        # # SIMULATION PARAMETERS
        # 'dt'              : 0.005,    # Simulation timestep (in ms)
        # 'tstop'               : 10,       # Total simulation time (in ms)
        # # HFS PARAMETERS
        # 'HFSreferenceNode'  : 2,  # Node of Ranvier where KHFAC stimulation is applied
        # 'HFSamp'          : 0.0,      # Amplitude of KHFAC waveform (mA)
        # 'HFSfrequency'        : 10.0,     # Frequency of KHFAC waveform (kHz)
        # 'HFSdelay'            : 5.0,      # Time when KHFAC waveform starts (ms)
        # 'HFSx'                : 0.0,      # Location of the KHFAC electrode on the x-axis
        # 'HFSy'                : 0.0,      # Location of the KHFAC electrode on the y-axis
        # 'HFSz'                : 1000.0,   # Location of the KHFAC electrode on the z-axis
        # 'tonset'          : 10,       # Duration of onset response
        # 'bipolar'           :  0,       # Set to 1 for bipolar electrode
        # # PARAMETERS FOR INTRACELLULAR STIMULUS
        # 'intrinsicStim'     : 0,  # Change to 1 to add intrinsic pulse(train)
    }

    if config=='AdultHuman':
        # Create single AP
        par.update({
            'myelinate_ax'      :   1    ,   # myelinate axon by default
            'scale_axon_diam'   :   2.453,   # Zhu 2000 L5 PC soma scaling
            'scale_apic_diam'   :   1.876,   # Romand 2011 L5 PC
            'scale_basal_diam'  :   1.946,   # Romand 2011 
            'scale_soma_area'   :   2.453,   # Zhu 2000
            'scale_basal_L'     :   1.17 ,   # Romand 2011
            'min_myelinD'       :   0.2  ,   # Waxman 1970
            'max_myelin_order'  :   0    ,   
            'celsius'           :   37.0 ,   # Temperature
        
        })

    elif config=='AdultRat':
        par.update({
            'myelinate_ax'      :   1    ,   # myelinate axon by default
            'scale_axon_diam'   :   1.322,   # Zhu 2000 L5 PC soma scaling
            'scale_apic_diam'   :   1.248,   # Romand 2011 L5 PC
            'scale_basal_diam'  :   1.133,   # Romand 2011 
            'scale_soma_area'   :   1.322,   # Zhu 2000
            'scale_basal_L'     :   1.17 ,   # Romand 2011
            'min_myelinD'       :   0.2  ,   # Waxman 1970
            'max_myelin_order'  :   0    ,   
            'celsius'           :   37.0    # Temperature
        })

    recpar = {  # Parameters used for recording
        # 'record'          : True,
        # 'plot'                : False,
        # 'nodes'               : np.array(range(0, int(par['axonnodes']))  ), # Nodes that are to be recorded
        'recordVoltage'     : True,     # Switch to allow recording of voltages
    }

    return par, recpar


def setParams(config):
    par, recpar = selectConfig(config)
    for k, v in par.items():
        exec('h.' + k + '=' + str(v))        
        
def setMeta(config, cell_id):
    from model import calcLocspace
    
    if config == 'detailed_allshapes':
        z = True
        meta = {
        'cell_id'           :   cell_id,
        'cell'              :   str(h.cell),
        'dt'                :   0.005, 
        'min_distance'      :   30,
        'max_distance'      :   500,
        'distance_step'     :   200,
        'dlist'             :   [0.05, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1, 1.25, 1.5, 2.5, 3.5, 5],
        # 'min_dur'           :   0.05,
        # 'max_dur'           :   1.5,
        # 'dur_step'          :   0.05,
        'shapelist'         :   ['r', 'g', 's', 't'],
        'polaritylist'      :   [0],
        'anglelist'         :   [0],
        'resolution_depth'  :   -1, 
        'date'              :   date.today().strftime("%d/%m/%y") #current date in dd/mm/yy
        }
        meta['xlist'], meta['ylist'], meta['zlist'], meta['loclist'] = calcLocspace(meta['min_distance'], meta['max_distance'], meta['distance_step'], z)

    elif config == 'detailed_finalset':
        z = True
        meta = {
        'cell_id'           :   cell_id,
        'cell'              :   str(h.cell),
        'dt'                :   0.005, 
        'min_distance'      :   30,
        'max_distance'      :   500,
        'distance_step'     :   200,
        'dlist'             :   np.append([0.01], np.arange(0.05, 1.51, 0.05)),
        # 'min_dur'           :   0.05,
        # 'max_dur'           :   1.5,
        # 'dur_step'          :   0.05,
        'shapelist'         :   ['r', 'g', 's', 't', 'ru', 'rd'],
        'polaritylist'      :   [0],
        'anglelist'         :   [0],
        'resolution_depth'  :   -1, 
        'date'              :   date.today().strftime("%d/%m/%y") #current date in dd/mm/yy
        }
        meta['xlist'], meta['ylist'], meta['zlist'], meta['loclist'] = calcLocspace(meta['min_distance'], meta['max_distance'], meta['distance_step'], z)
    
    elif config == 'detailed_extendeddur':
        z = True
        meta = {
        'cell_id'           :   cell_id,
        'cell'              :   str(h.cell),
        'dt'                :   0.005, 
        'min_distance'      :   30,
        'max_distance'      :   500,
        'distance_step'     :   200,
        'dlist'             :   np.concatenate((np.arange(0.05, 1, 0.05), np.arange(1, 3, 0.1), np.arange(3, 5.5, 0.5))), # steps of 50us from 50us-1ms, steps of 100us from 1ms-3ms, steps of .5ms from 3-5ms
        # 'min_dur'           :   0.05,
        # 'max_dur'           :   1.5,
        # 'dur_step'          :   0.05,
        'shapelist'         :   ['r', 'g', 's', 't'],
        'polaritylist'      :   [0],
        'anglelist'         :   [0],
        'resolution_depth'  :   -1, 
        'date'              :   date.today().strftime("%d/%m/%y") #current date in dd/mm/yy
        }
        meta['xlist'], meta['ylist'], meta['zlist'], meta['loclist'] = calcLocspace(meta['min_distance'], meta['max_distance'], meta['distance_step'], z)
    
    elif config == 'fast_allshapes':
        z = False
        meta = {
        'cell_id'           :   cell_id,
        'cell'              :   str(h.cell),
        'dt'                :   0.025, 
        'min_distance'      :   30,
        'max_distance'      :   500,
        'distance_step'     :   200,
        'dlist'             :   [0.1, 0.2, 0.3, 0.4],
        # 'min_dur'           :   0.1,
        # 'max_dur'           :   0.4,
        # 'dur_step'          :   0.1,
        'shapelist'         :   ['r', 'g', 's', 't'],
        'polaritylist'      :   [0],
        'anglelist'         :   [0],
        'resolution_depth'  :   -2, 
        'date'              :   date.today().strftime("%d/%m/%y") #current date in dd/mm/yy
        }
        meta['xlist'], meta['ylist'], meta['zlist'], meta['loclist'] = calcLocspace(meta['min_distance'], meta['max_distance'], meta['distance_step'], z)
    
    elif config == 'fast_test':
        z = False
        meta = {
        'cell_id'           :   cell_id,
        'cell'              :   str(h.cell),
        'dt'                :   0.025, 
        'min_distance'      :   30,
        'max_distance'      :   100,
        'distance_step'     :   200,
        'dlist'             :   [0.1, 0.2],
        # 'min_dur'           :   0.1,
        # 'max_dur'           :   0.2,
        # 'dur_step'          :   0.1,
        'shapelist'         :   ['r'],
        'polaritylist'      :   [0],
        'anglelist'         :   [0],
        'resolution_depth'  :   -2, 
        'date'              :   date.today().strftime("%d/%m/%y") #current date in dd/mm/yy
        }
        meta['xlist'], meta['ylist'], meta['zlist'], meta['loclist'] = calcLocspace(meta['min_distance'], meta['max_distance'], meta['distance_step'], z)
        meta['loclist'] = [meta['loclist'][0], meta['loclist'][20]]
    elif config == 'sigma_sweep':
        z = False
        meta = {
        'cell_id'           :   cell_id,
        'cell'              :   str(h.cell),
        'dt'                :   0.025, 
        'min_distance'      :   30,
        'max_distance'      :   100,
        'distance_step'     :   200,
        'dlist'             :   np.arange(0.1, 2.1, 0.1),
        # 'min_dur'           :   0.1,
        # 'max_dur'           :   2,
        # 'dur_step'          :   0.1,
        'shapelist'         :   ['gt'],
        'polaritylist'      :   [0],
        'anglelist'         :   [0],
        'resolution_depth'  :   -2, 
        'date'              :   date.today().strftime("%d/%m/%y"), #current date in dd/mm/yy
        'loclist'           :   [(-800, -500, 0)],
        'sigmalist'         :   [0.1, 0.15, 0.2]
        }
    elif config == 'shift_test':
        z = False
        meta = {
        'cell_id'           :   cell_id,
        'cell'              :   str(h.cell),
        'dt'                :   0.0125, 
        'min_distance'      :   30,
        'max_distance'      :   100,
        'distance_step'     :   200,
        'dlist'             :   np.arange(0.1, 1.1, 0.1),
        # 'min_dur'           :   0.1,
        # 'max_dur'           :   1,
        # 'dur_step'          :   0.1,
        'shapelist'         :   ['gts'],
        'polaritylist'      :   [0],
        'anglelist'         :   [0],
        'resolution_depth'  :   -2, 
        'date'              :   date.today().strftime("%d/%m/%y"), #current date in dd/mm/yy
        'loclist'           :   [(300, 500, 0)],
        'sigmalist'         :   [0.2, 0.5, 0.8]
        }       
        
    return meta
