# -*- coding: utf-8 -*-
"""
Created on Fri Oct  8 16:11:32 2021

@author: francescvarkev
"""

from multiprocessing import Pool
from functools import partial
from config import setMeta
from time import time
from simulationfunctions import parallel_add_durpoints, loadPickle
from model import initCell, quitNeuron
import os
import pickle
import sys
import numpy as np

def f(loc, cell_id, meta, durlist):
    parallel_add_durpoints(loc, cell_id, meta, durlist)

if __name__ == '__main__':
    tic = time()
    cell_id = sys.argv[1]
    print(cell_id)
    meta = loadPickle('Datafiles/' + str(cell_id) + '/meta.pkl')
    loclist = meta['loclist']
    durlist = np.concatenate((np.arange(0.05, 1, 0.05), np.arange(1, 3, 0.1), np.arange(3, 5.5, 0.5))) # steps of 50us from 50us-1ms, steps of 100us from 1ms-3ms, steps of .5ms from 3-5ms

    with Pool(30) as p:
        p.map(partial(f, cell_id=cell_id, meta=meta, durlist=durlist), loclist)
        # print(p.map(loc, loclist))

    meta['dlist'] = durlist
    a_file = open("Datafiles/" + str(cell_id) + '/meta.pkl', "wb")
    pickle.dump(meta, a_file)
    a_file.close()

    elapsed_time = (time() - tic)/3600
    text_file = open("Datafiles/" + str(cell_id) + '/elapsedtime.txt', "a")
    text_file.write(str(elapsed_time))
    text_file.close()
    quitNeuron()


