# -*- coding: utf-8 -*-
"""
Created on Mon Oct 25 14:32:17 2021

@author: francescvarkev
"""

import pandas as pd
from scipy.integrate import simps 
import numpy as np
from Dataconversion import loadPickle
import pickle 

data = {}
for i in [16, 17, 18, 19, 20]:
    tmp = loadPickle(f'DatafilesFinal/{i}/Data.pkl') ## Create data with all cells combined.
    data[i] = tmp[i]
    print('Loaded', i)
    
del tmp
#%%
# a_file = open('Datafiles/DataDictLayer5.pkl', "wb")
# pickle.dump(data, a_file)
# a_file.close()
# print('Dictfile saved')
#%%
cell_ids = []
x = []
y = []
z = []
bipolars = []
angles = []
count = []
durs = []
ths = []
es = []
qs = []
ws = []
locs = []
i=0

result = []
for cell_id in data:
    for loc in data[cell_id]:
        for w in data[cell_id][loc]:
            for bipolar in data[cell_id][loc][w]:
                for angle in data[cell_id][loc][w][bipolar]:
                    for dur in data[cell_id][loc][w][bipolar][angle]['SD']:
                        # th = data[cell_id][loc][w][bipolar][angle]['SD'][dur]['th']
                        # e = data[cell_id][loc][w][bipolar][angle]['SD'][dur]['e']
                        # q = data[cell_id][loc][w][bipolar][angle]['SD'][dur]['q']
                        # vm_ex = data[cell_id][loc][w][bipolar][angle]['SD'][dur]['vm_ex']
                        result.append((cell_id, str(loc), w, bipolar, angle, dur, \
                                        data[cell_id][loc][w][bipolar][angle]['SD'][dur].get('data'), \
                                        data[cell_id][loc][w][bipolar][angle]['SD'][dur].get('q'), \
                                        data[cell_id][loc][w][bipolar][angle]['SD'][dur].get('pwr'), \
                                        data[cell_id][loc][w][bipolar][angle]['SD'][dur].get('e'), \
                                        data[cell_id][loc][w][bipolar][angle]['SD'][dur].get('t'), \
                                        data[cell_id][loc][w][bipolar][angle]['SD'][dur].get('th'), \
                                        data[cell_id][loc][w][bipolar][angle]['SD'][dur].get('ex'), \
                                        data[cell_id][loc][w][bipolar][angle]['SD'][dur].get('dt'), \
                                        data[cell_id][loc][w][bipolar][angle]['SD'][dur].get('biphasic'), \
                                        data[cell_id][loc][w][bipolar][angle]['SD'][dur].get('ex_loc'), \
                                        data[cell_id][loc][w][bipolar][angle]['SD'][dur].get('t_onset'), \
                                        data[cell_id][loc][w][bipolar][angle]['SD'][dur].get('vm_ex'), \
                                        data[cell_id][loc][w][bipolar][angle]['SD'][dur].get('t_ex'), \
                                        data[cell_id][loc][w][bipolar][angle].get('dist'), \
                                        ))
                        # cell_ids.append(cell_id)
                        # x.append(loc[0])
                        # y.append(loc[1])
                        # z.append(loc[2])
                        # locs.append(str(loc))
                        # bipolars.append(bipolar)
                        # angles.append(angle)
                        # durs.append(dur)
                        # ws.append(w)
columns = ['cell_id', 'loc', 'shape', 'bipolar', 'angle', 'dur', 'data', 'q', 'pwr', 'e', 't', 'th', 'ex', 'dt', 'biphasic', 'ex_loc', 't_onset', 'vm_ex', 't_ex', 'dist']


# data_list = []            
# for res in zip(ws, bipolars, angles, durs, ths, es, qs):
#     data_list.append(res)
  
df = pd.DataFrame(result, columns = columns)
del result

df = df.loc[:,~df.columns.duplicated()] #delete duplicated columns

df = df.astype({'cell_id':'int8', 'loc':'category', 'shape':'category', 'bipolar':'bool', 'angle':'bool', 'biphasic':'bool'})
for column in ['q', 'e', 'th', 'dt', 'dur', 'dist']:
    df[column] = pd.to_numeric(df[column], downcast='float')
    
df.to_pickle('DatafilesFinal/DataFrame_raw.pkl')

#%% Throw away unimportant stuff that takes up lots of memory.      
for column in df.columns:
    if df[column].dtype == 'O':
        df = df.drop(columns=column)
        
df.to_pickle('DatafilesFinal/DataFrame_all.pkl')
#%%

# result = []
# for cell_id in df['cell_id'].unique():
#     for loc in df.query(f'cell_id == {cell_id}')['loc'].unique():
#         for dur in df.query(f'cell_id == {cell_id} & loc == "{loc}"')['dur'].unique():
#             th_list = list(df.query(f'cell_id == {cell_id} & loc == "{loc}" & dur == {dur}')['th'].values)
#             e_list = list(df.query(f'cell_id == {cell_id} & loc == "{loc}" & dur == {dur}')['e'].values)
#             q_list = list(df.query(f'cell_id == {cell_id} & loc == "{loc}" & dur == {dur}')['q'].values)
#             sub = [cell_id, loc, dur] + th_list + e_list + q_list 
#             result.append(sub)    

# df_sum = pd.DataFrame(result, columns = ['cell_id', 'loc', 'dur'] + [f'th_{w}' for w in df['shape'].unique()] + [f'e_{w}' for w in df['shape'].unique()] + [f'q_{w}' for w in df['shape'].unique()])
# # df.to_pickle('DataFrame_all.pkl')
# ## Create Dataframes with average, optimal, other values.

# df_sum.to_pickle('DatafilesFinal/DataFrame_sum.pkl')
# #%%
# result = []
# shapelist = ['r', 'g', 's', 't']
# for cell_id in df_sum['cell_id'].unique():
#     for loc in df_sum.query(f'cell_id == {cell_id}')['loc'].unique():
#         opt_pw = []
#         opt_e = []
#         opt_q = []
#         opt_th = []
#         for shape in df['shape'].unique():
#             opt_idx = df_sum.query(f'cell_id == {cell_id} & loc == "{loc}"')[f'e_{shape}'].idxmin()
#             opt_pw.append(df_sum.loc[opt_idx]['dur']) # determine opt_pw for all shapes    
#             opt_e.append(df_sum.loc[opt_idx][f'e_{shape}'])
#             opt_q.append(df_sum.loc[opt_idx][f'e_{shape}'])
#             opt_th.append(df_sum.loc[opt_idx][f'th_{shape}'])
        
#         sub = [cell_id, loc] + opt_pw + opt_e + opt_q + opt_th
#         result.append(sub)
        
# df_opt = pd.DataFrame(result, columns = ['cell_id', 'loc'] + [f'pw_{w}' for w in df['shape'].unique()] + [f'e_{w}' for w in df['shape'].unique()] + [f'q_{w}' for w in df['shape'].unique()] + [f'th_{w}' for w in df['shape'].unique()])
        
# for shape in df['shape'].unique():  
#     df_opt[f'save_e_{shape}'] = 1 - df_opt[f'e_{shape}']/df_opt['e_r']
#     df_opt[f'save_q_{shape}'] = 1 - df_opt[f'q_{shape}']/df_opt['q_r']
#     df_opt[f'save_th_{shape}'] = 1 - df_opt[f'th_{shape}']/df_opt['th_r']
#     df_opt[f'shift_pw_{shape}'] = df_opt[f'pw_{shape}']/df_opt['pw_r']
        
       
# df_opt.to_pickle('Datafiles/DataFrame_opt.pkl')      
        

# #%%
# df = pd.read_pickle('DataFiles/DataFrame_raw.pkl')
# print('Dataframe loaded')
# dist = []
# for i in range(len(df)):
#     cell_id = df.iloc[i]['cell_id']
#     loc = df.iloc[i]['loc']
#     w = df.iloc[i]['shape']
#     dist.append(data[cell_id][loc][w][0][0].get('dist'))

# df['dist'] = dist
# print('Distance done')
# #%%
# del data

# qlist = []
# eCdl_const = []
# eCdl_adapt = []
# for i in range(len(df)):
#     wave = df.iloc[i]['data']
#     t = df.iloc[i]['t']
#     q_tmp = [simps(wave[:i], t[:i]) for i in range(1, len(t)+1)] # creat an array q, where q(t) is the integral of 'wave' from 0 to t.
#     qlist.append(q_tmp)
#     pwr_with_adapt = np.multiply(wave, (wave+np.multiply(q_tmp, 1/25))) # calculate power with Cdl using an adaptive supply -> pwr = I*(I*R + q/C). By assuming C = 10/R, pwr = R*I*(I+ q/10)
#     pwr_with_const = np.multiply(wave, -max(np.abs((wave+np.multiply(q_tmp, 1/25))))) # calculate power with Cdl and constant supply -> pwr = I*Vmax, where Vmax = max(I+q/10)
#     eCdl_const.append(simps(pwr_with_const, t))
#     eCdl_adapt.append(simps(pwr_with_adapt, t))
    
# df['qlist'] = qlist
# df['eCdl_const'] = eCdl_const
# df['eCdl_adapt'] = eCdl_adapt
# print('Ecalc done')
# df.to_pickle('Datafiles/DataFrame_raw.pkl')
# print('Raw dataframe saved')
# #%%     
# for column in df.columns:
#     if df[column].dtype == 'O':
#         df = df.drop(columns=column)
        
# df.to_pickle('Datafiles/DataFrame_all.pkl')    
    