import numpy as np
import scipy as sc
from scipy import constants
import qcodes as qc
configuration = qc.config

def n_complex(absolute, phase):
    '''Returns complex value for magnitude and phase'''
    return absolute*np.exp(1j*phase)

def dB2mW(dB):
    '''Returns power in mW from power in dB'''
    return 10**(dB/10.)

def dB2V(dB):
    '''Returns voltage in V from voltage in dB'''
    return 10**(dB/20.)

def V2dB(V):
    '''Returns voltage in dB from voltage in V'''
    return 20*np.log10(V)

def averagephotonnumber(Qi, Qc, power, freq):
    '''Returns average intra-cavity photon number for notch type/hanger resonator derived from input/output theory.

    Keyword arguments:
    Qi -- internal quality factor
    Qc -- coupling quality factor
    power -- power in transmission line at input port in Watts
    freq -- resonance frequency resonator
    '''
    Qt = 1/(1/Qc+1/Qi)
    flux = power/(sc.constants.h*freq)
    return 2*Qt**2*flux/(2*np.pi*freq*Qc)
