# Research Dataset: Understanding Unreflective Habit Formation on TikTok

This dataset accompanies the research project titled *Understanding unreflective habit formation on TikTok as a system safety problem: an explorative study in Vietnam*. It includes materials related to qualitative interviews conducted for this study.

## Description of Files

- **Interview_protocols.docx**  
  This Word document outlines the interview procedure, including the structure of the sessions, ethical considerations, and sample interview questions used with participants.
- **Interview_registration_form.pdf**  
  This is the informed consent form participants signed before taking part in the study. It explains the purpose of the research, confidentiality terms, and participants’ rights.
- **Int_1.docx to Int_12.docx**  
  These are anonymized interview transcripts from 12 participants, saved as individual Word documents. Each file corresponds to a unique participant (e.g., `Int_1.docx` = Interviewee 1).
- **TikTok_Cooccurrence_Table.xlsx**  
  This Excel file presents the co-occurrence matrix of thematic codes generated during the qualitative analysis. It shows how often different codes appeared together across the interview data, aiding in the identification of thematic relationships.
- **TikTok_CodeBook.xlsx**  
  This Excel file contains the codebook exported from ATLAS.ti. It includes themes, subthemes, and code descriptions derived from a thematic analysis of the interview transcripts.

## Ethical Considerations

All interviews were conducted with informed consent and in compliance with ethical research standards. Personal identifiers have been removed from the transcripts to protect participant anonymity.

## Related Publication

This dataset supports the following thesis:  
Tran, N. (2025). *Understanding unreflective habit formation on TikTok as a system safety problem: an explorative study in Vietnam*. Delft University of Technology.  
Available at: [https://resolver.tudelft.nl/uuid:8dbf1f56-7523-4483-926a-4bad35cf3e0f](https://resolver.tudelft.nl/uuid:8dbf1f56-7523-4483-926a-4bad35cf3e0f)
