# Data, code and results underlying the publication: Spatial clustering of waste reuse in a circular economy

This repository contains the dataset, code, and results of the academic paper titled "Spatial clustering of waste reuse in a circular economy: A spatial autocorrelation analysis on locations of waste reuse in the Netherlands using global and local Moran’s I". The paper analyzes the degree and scale of spatial clustering of waste reuse locations in the Netherlands, employing waste data from the Dutch Waste Registry (LMA). You can access the paper at this [link](https://www.frontiersin.org/articles/10.3389/fbuil.2022.954642/full).

The dataset is contained in a zipfile that encompasses the following folders:

1. `Results` - This folder houses the results of spatial analysis of waste reuse locations in the Netherlands, including global Moran's I (spatial clustering) and local Moran's I (hotspot analysis).

2. `wasteReuseLocations` - This folder includes shp files of waste reuse locations in the Netherlands, aggregated at a spatial resolution of 10x10km.

3. `code` - This folder contains the Python scripts (.py) and Jupyter Notebook (.ipynb) files utilized to conduct the spatial clustering analysis.

Additionally, a `supplementary document.docx` is included, providing additional information on the methodology and results of the paper, along with relevant links.

## Detailed folder information:

### Code

- `paper2Functions.py`: This Python script cleans the waste reuse location data and measures spatial clustering of waste reuse using Global Moran's I. It also identifies waste reuse hotspot locations using Local Moran's I.

- `paper2Results.ipynb`: A Jupyter Notebook that runs functions from `paper2Functions.py` and visualizes the results.

### Results

- `01_Global Moran's I`: This folder contains HTML files that showcase the results of spatial clustering for waste reuse. Clicking these HTML files will open an interactive chart in your web browser.

- `02_Local Moran's I`: This folder includes HTML files that illustrate the hotspots and cold spots for waste reuse in the Netherlands. Opening these HTML files will launch interactive maps in your web browser displaying the hotspots and cold spots.

- `03_resultsAnalysis`: This folder includes HTML files that provide further analysis of the results. For more details on these charts, please refer to our paper.

## Usage

Download the entire repository as a ZIP file. After extraction, you will have full access to all files. Make sure you have the necessary software (Python, Jupyter Notebook, a web browser) to run and view these files.

## Citation

If you use this data or code in your work, please cite our paper. The citation details can be found in the linked paper above.

## Contact

For any queries or issues related to the data, please contact the corresponding author, Tanya Tsui, at t.p.y.tsui@tudelft.nl 

## License

This work is licensed under a Creative Commons Attribution 4.0 International License. For more details, see the LICENSE file in this repository.