# Data repository for "A full parity phase diagram of a Majorana island"

This repository gathers the data analysis and plotting code required to reproduce the results of our work.

## CONTENTS: DATA

### Experimental data

The experimental raw data for all the figures published in our work is contained in the folder `raw_data`.
The data has been saved in `csv` format after a minor clean up of the original data files - e.g. eliminating unnecessary data columns, renaming the columns, and adjusting the physical units to convenient ones. Other than this, no other processing has been performed on the raw data stored in the files. A more detailed guide to each file is contained in `metadata.csv`.
This file also contains metadata that is needed in the post-processing of the raw data, such as lock-in measurement parameters scraped from the original measurement scripts.
The column names in the file have the following meaning and physical units:

* `pg`, `pg_fine` or `pg_coarse`: Plunger gate voltage in mV (in Fig. 2, S6 and S7, it is stepped via both fine and coarse steps in the course of a measurement)
* `rtg` : Right tunnel gate voltage, in mV
* `field` : Magnetic field in T
* `bias` : bias voltage in μV
* `X`, `Y` : recorded output of the lock-in quadratures, to be converted to conductance in the post-processing

Relevant values of experimental parameters not varied during the measurements are indicated in the main text.

### Numerical simulations data

In the folder `sim_data` we provide pickled output files of our simulations that are displayed in the figures.

## CONTENTS: CODE

We provide three jupyter notebooks (saved in markdown format for convenience) that can be used to reproduce all the results:

* `figures_main_text.md` reproduces the experimental figures of the main text
* `figures_supplementary.md` reproduces the experimental figures of the supplementary
* `figures_numerical_simulations.md` reproduces the simulation figures

These three notebooks rely on a Python module, `cbo.py`, which gathers common routines used in the analysis.
Each notebook is divided in sections dedicated to a single figure. All the data analysis steps to go from the raw data to the final result are contained in this figure.
Some post-processing steps are common to each figure: in particular, the lock-in quadratures are converted to conductance. All the figures in the manuscript are generated via `matplotlib`, without further image processing.

# HOW TO

The analysis that generates the figures relies on standard scientific packages for Python: `numpy`, `scipy`, `pandas`, ... , as detailed in `environment.yml`.
Install [miniconda](http://conda.pydata.org/miniconda.html) and then the Python environment that contains all dependencies with:

```
conda env create -f environment.yml
```

then activate it with
```
conda activate parity_diagram
```

Finally, open a jupyter notebook to run the notebooks.
We note that the [`jupytext`](https://github.com/mwouts/jupytext) extension can be used to open the jupyter notebooks directly as markdown files.
For any questions about this repository, please contact `bernard.vanheck@microsoft.com`.
