import numpy as np
import matplotlib.pyplot as plt
import cartopy.crs as ccrs


def maximize(backend=None,fullscreen=False):
    """Maximize window independently on backend.
    Fullscreen sets fullscreen mode, that is same as maximized, but it doesn't have title bar (press key F to toggle full screen mode)."""
    if backend is None:
        import matplotlib
        backend=matplotlib.get_backend()
        print("This is backend: ", backend)
    mng = plt.get_current_fig_manager()
    print("This is mng: ", mng)
    if fullscreen:
        mng.full_screen_toggle()
    else:
        if backend == 'wxAgg':
            mng.frame.Maximize(True)
        elif backend == 'Qt4Agg' or backend == 'Qt5Agg' or backend == 'QtAgg':
            mng.window.showMaximized()
        elif backend == 'TkAgg':
            # mng.window.state('iconic') #works fine on Windows! # In fedora: normal, iconic, or withdrawn
            mng.resize(*mng.window.maxsize()) # This one works on Linux/Fedora
        else:
            print ("Unrecognized backend: ",backend) #not tested on different backends (only Qt)

    plt.show(block=False)
    plt.pause(2)
    plt.close()

def trim_columns_for_each_experiment(name_exp, df_dmg):
    if name_exp == "landuse-cobra":
        pass
    elif name_exp == "no-landuse-cobra":
        df_dmg.drop(columns=["BG2017"], inplace=True)
    elif name_exp == "landuse-no-cobra":
        df_dmg.drop(columns=['trees_pixel', 'trees_buff', 'closest_tree', 'avg_dist'], inplace=True)
    elif name_exp == "no-landuse-no-cobra":
        df_dmg.drop(columns=['BG2017', 'trees_pixel', 'trees_buff', 'closest_tree', 'avg_dist'], inplace=True)
    return df_dmg