%% Function to calculate statistics on the bootstrapping samples and their LOESS fitted results
function [mean_org,mean_org_short,std_org,mean_1st,std_1st,corrcoef_1st,RMSE_1st,RMSE_Gupta_1st] = bootstrapping_statistics(VI_bootstrap_nan_A,VI_bootstrap_nan_B,bedprofile,bedprofile_wet)

N = size(VI_bootstrap_nan_A,1);

mean_org = nan(N,2);
std_org = nan(N,2);
corrcoef_org = nan(3,N);
RMSE_org = nan(3,N);
RMSE_Gupta_org = nan(N,1);

mean_1st = nan(N,2);
std_1st = nan(N,2);
corrcoef_1st = nan(N,1);
RMSE_1st = nan(N,1);
RMSE_Gupta_1st = nan(N,1);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

ind_dum = find(bedprofile(:,1)>1500&bedprofile(:,1)<11000);

for i=1:N
    mean_org(i,1) = nanmean(nanmean(VI_bootstrap_nan_A{i,2}(:,:),2),1);
    mean_org_short(i,1) = nanmean(nanmean(VI_bootstrap_nan_A{i,2}(ind_dum,:),2),1);
    mean_org(i,2) = nanmean(nanmean(VI_bootstrap_nan_A{i,3}{3},2),1);
    std_org(i,1) = nanstd(reshape(VI_bootstrap_nan_A{i,2}(:,:),[],1));
    std_org(i,2) = nanstd(reshape(VI_bootstrap_nan_A{i,3}{3},[],1));
    
    XI_A = nan(size(VI_bootstrap_nan_A{i,2},1),144);
    for j=1:144
        XI_A(:,j) = bedprofile(:,1);
    end
    XI_A = reshape(XI_A,[],1);
    YI_A = reshape(bedprofile(:,4:147),[],1);
    VI_A_raw = reshape(bedprofile(:,148:end),[],1);
    VI_A = reshape(VI_bootstrap_nan_A{i,2},[],1);
%     XI_A(isnan(VI_A)) = [];
%     YI_A(isnan(VI_A)) = [];
%     VI_A(isnan(VI_A)) = [];
    XI_A_loess = reshape(VI_bootstrap_nan_A{i,3}{1},[],1);
    YI_A_loess = reshape(VI_bootstrap_nan_A{i,3}{2},[],1);
    VI_A_loess = reshape(VI_bootstrap_nan_A{i,3}{3},[],1);
%     XI_A_loess(isnan(VI_A_loess)) = [];
%     YI_A_loess(isnan(VI_A_loess)) = [];
%     VI_A_loess(isnan(VI_A_loess)) = [];
    VI_B_loess = reshape(VI_bootstrap_nan_A{i,4}{3},[],1);
    
    index = knnsearch([XI_A YI_A],[XI_A_loess YI_A_loess]);
    
    dum_corrcoef = corrcoef(VI_A,VI_A_raw,'rows','pairwise');
    corrcoef_org(1,i) = dum_corrcoef(1,2);
    dum_corrcoef = corrcoef(VI_A_loess,VI_A_raw(index),'rows','pairwise');
    corrcoef_org(2,i) = dum_corrcoef(1,2);
    dum_corrcoef = corrcoef(VI_B_loess,VI_A_raw(index),'rows','pairwise');
    corrcoef_org(3,i) = dum_corrcoef(1,2);
    RMSE_org(1,i) = sqrt(nanmean(nanmean((VI_A-VI_A_raw).^2,2),1));
    RMSE_org(2,i) = sqrt(nanmean(nanmean((VI_A_loess-VI_A_raw(index)).^2,2),1));
    RMSE_org(3,i) = sqrt(nanmean(nanmean((VI_B_loess-VI_A_raw(index)).^2,2),1));
    RMSE_Gupta_org(i) = sqrt( 2*std_org(i,1)*std_org(i,2)*(1-corrcoef_org(i)) + (std_org(i,1)-std_org(i,2))^2 + (mean_org(i,1)-mean_org(i,2))^2 );
    
% %     mean_1st(i,1) = nanmean(nanmean(VI_bootstrap_nan_B{i,2},2),1);
    mean_1st(i,1) = nanmean(nanmean(VI_bootstrap_nan_A{i,4}{3},2),1);
% %     std_1st(i,1) = nanstd(reshape(VI_bootstrap_nan_B{i,2},[],1));
    std_1st(i,1) = nanstd(reshape(VI_bootstrap_nan_A{i,4}{3},[],1));
%     dum_corrcoef = corrcoef(reshape(VI_bootstrap_nan_B{i,2},[],1),reshape(VI_bootstrap_nan_B{i,3}{3},[],1),'rows','pairwise');
%     corrcoef_1st(i) = dum_corrcoef(1,2);
%     RMSE_1st(i) = sqrt(nanmean(nanmean((VI_bootstrap_nan_B{i,2}-VI_bootstrap_nan_B{i,3}{3}).^2,2),1));
%     RMSE_Gupta_1st(i) = sqrt( 2*std_1st(i,1)*std_1st(i,2)*(1-corrcoef_1st(i)) + (std_1st(i,1)-std_1st(i,2))^2 + (mean_1st(i,1)-mean_1st(i,2))^2 );
end

sprintf(['average mean dry bed = %f\n' ...
'average std dry bed = %f\n\n' ...
'average mean submerged = %f\n' ...
'average std submerged = %f\n\n' ...
'average mean A = %f\n' ...
'average mean A short = %f\n' ...
'average mean A LOESS = %f\n' ...
'average std A = %f\n' ...
'average std A LOESS = %f\n' ...
'average RMSE A = %f\n' ...
'average RMSE Gupta A = %f\n\n' ...
'average mean B LOESS = %f\n' ...
'average std B LOESS = %f\n' ...
'average corrcoef org = %f\n' ...
'average corrcoef A = %f\n' ...
'average corrcoef B = %f\n\n' ...
'average RMSE org/dry = %f\n' ...
'average RMSE A/dry = %f\n' ...
'average RMSE B/dry = %f\n'], ...
-nanmean(nanmean(bedprofile(:,148:end),2),1), ...
nanstd(reshape(bedprofile(:,148:end),[],1)), ...
-nanmean(nanmean(bedprofile_wet(:,148:end),2),1), ...
nanstd(reshape(bedprofile_wet(:,148:end),[],1)), ...
-mean(mean_org(:,1)),-mean(mean_org_short(:,1)),-mean(mean_org(:,2)), ...
mean(std_org(:,1)),mean(std_org(:,2)), ...
mean(RMSE_org(2,:)),mean(RMSE_Gupta_org), ...
-mean(mean_1st(:,1)), ... 
mean(std_1st(:,1)), ... 
mean(corrcoef_org(1,:)),mean(corrcoef_org(2,:)),mean(corrcoef_org(3,:)), ...
mean(RMSE_org(1,:)),mean(RMSE_org(2,:)),mean(RMSE_org(3,:)))

figure; plot(bedprofile(17254:23003,1),-bedprofile(17254:23003,250),'-k'); hold on; plot(VI_bootstrap_nan_A{1,3}{1}(94,:),-VI_bootstrap_nan_A{1,3}{3}(94,:)); hold on; plot(bedprofile(17254:23003,1),-VI_bootstrap_nan_A{1,2}(17254:23003,250-147),'.','markersize',5); hold on; plot(VI_bootstrap_nan_A{1,4}{1}(94,:),-VI_bootstrap_nan_A{1,4}{3}(94,:));
% figure; plot(bedprofile(17254:23003,1),-bedprofile(17254:23003,250),'-k'); hold on; plot(VI_bootstrap_nan_A{1,4}{1}(94,:),-VI_bootstrap_nan_A{1,4}{3}(94,:)); hold on; plot(VI_bootstrap_nan_B{1,3}{1}(94,:),-VI_bootstrap_nan_B{1,2}(94,:),'.','markersize',5);

end

% 'average mean B = %f\n' ...
% 'average std B = %f\n' ...

% 'average RMSE B = %f\n' ...
% 'average RMSE Gupta B = %f\n\n' ...
% -mean(mean_1st(:,2)), ...
% mean(std_1st(:,2)), ...
% mean(RMSE_1st),mean(RMSE_Gupta_1st), ...