%% Function to calculate bootstrap samples for missing values, based on bed profile data with and without water.
function [p_nan,p_scat,elements_nan,elements_scat,elements_total,elements_total_nonan,VI_bootstrap_ns_A,VI_bootstrap_ns_B,XYZ_dry,XYZ_cb,XYZ_cb_2nd] = bootstrapping_nan_scatter_bedprofile(bedprofile_corr,input_loess,N_bootstrap,bins_z,limits_z,total_shift)

% switch_loess: 0=only raw data; 1=only 1st loess; 2=only 2nd loess; 3=1st
% and 2nd loess; 4=raw data + 1st loess; 5=raw data + 2nd loess; 6=raw data
% + 1st and 2nd loess

% structure of output:
%   p_nan:              cell array with elements for raw, 1st loess and/or
%                       2nd loess; determining chance of NaN value per bin
%   elements_nan:       same size as p_nan; determining #NaN-values per bin
%   elements_total:     same size as p_nan; determining #values per bin
%   VI_bootstrap_nan_A: cell array for bootstrap samples (1st count, being
%                       raw, 1st loess or 2nd loess); rows determining
%                       sample number; columns determining rand-config,
%                       bootstrap z-values, loess-fitted bootstrap xyz
%   VI_bootstrap_nan_B: same as VI_bootstrap_nan_A, but for 2nd count
%   XYZ_dry:            cell array containing loess-fitted XYZ-matrices for
%                       dry profile
%   XYZ_cb:             same as XYZ_dry, but for celerity-corrected and
%                       (1st) loess-fitted submerged profile
%   XYZ_cb_2nd:         same as XYZ_cb, but after 2nd loess fit

counter = 0;

nbeams = 144;
xstart = 500;
xstop = 12000;
deltax = xstop - xstart;
nend_track = [5751,11502,17253,size(bedprofile_corr{1},1)];

if nargin < 8
    total_shift = 140;
    if nargin < 7
        epsilon_max = 30;
        epsilon_min = -30;
        if nargin < 6
            bins_epsilon = 62;
            if nargin < 5
                z_max = -300;
                z_min = -450;
                if nargin < 4
                    bins_z = 302;
                end
            else
                z_max = limits_z(2);
                z_min = limits_z(1);
            end
        end
    else
        epsilon_max = limits_epsilon(2);
        epsilon_min = limits_epsilon(1);
    end
end

if ~iscell(input_loess)
    switch_loess = input_loess;
elseif any(length(input_loess) == [1 4 7 10])
    switch_loess = input_loess{1};
    if length(input_loess) >= 4
        XYZ_dry{1} = input_loess{2};
        XYZ_dry{2} = input_loess{3};
        XYZ_dry{3} = input_loess{4};
        if length(input_loess) >= 7
            XYZ_cb{1} = input_loess{5};
            XYZ_cb{2} = input_loess{6};
            XYZ_cb{3} = input_loess{7};
            if length(input_loess) == 10
                XYZ_cb_2nd{1} = input_loess{8};
                XYZ_cb_2nd{2} = input_loess{9};
                XYZ_cb_2nd{3} = input_loess{10};
            end
        end
    end
else
    error('Invalid size of inpt argument input_loess.')
end    

lower_range_bins_z = nan(bins_z-1,1);
lower_range_bins_epsilon = nan(bins_epsilon-1,1);
if switch_loess <= 2
    p_nan = cell(1);
    p_scat = cell(1);
    elements_nan = cell(1);
    elements_total = cell(1);
    elements_total_nonan = cell(1);
elseif switch_loess == 6
    p_nan = cell(3,1);
    p_scat = cell(3,1);
    elements_nan = cell(3,1);
    elements_total = cell(3,1);
    elements_total_nonan = cell(3,1);
else
    p_nan = cell(2,1);
    p_scat = cell(2,1);
    elements_nan = cell(2,1);
    elements_total = cell(2,1);
    elements_total_nonan = cell(2,1);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% applying correction for bedform celerity to raw submerged bedform data

bedprofile_corr_cb = cell(1);

bedprofile_corr_cb{1} = bedprofile_corr{1};

bedprofile_corr_cb{1}(1:nend_track(1),1) = ((xstop-bedprofile_corr{1}(1:nend_track(1),1))/deltax+3)*total_shift + bedprofile_corr{1}(1:nend_track(1),1);
bedprofile_corr_cb{1}(nend_track(1)+1:nend_track(2),1) = ((bedprofile_corr{1}(nend_track(1)+1:nend_track(2),1)-xstart)/deltax+2)*total_shift + bedprofile_corr{1}(nend_track(1)+1:nend_track(2),1);
bedprofile_corr_cb{1}(nend_track(2)+1:nend_track(3),1) = ((xstop-bedprofile_corr{1}(nend_track(2)+1:nend_track(3),1))/deltax+1)*total_shift + bedprofile_corr{1}(nend_track(2)+1:nend_track(3),1);
bedprofile_corr_cb{1}(nend_track(3)+1:nend_track(4),1) = ((bedprofile_corr{1}(nend_track(3)+1:nend_track(4),1)-xstart)/deltax)*total_shift + bedprofile_corr{1}(nend_track(3)+1:nend_track(4),1);

% applying LOESS algorithm (1 or 2 times) to corrected raw data

if ~iscell(input_loess) || ( iscell(input_loess) && length(input_loess) == 1 )
    XYZ_dry = cell(1,3);
    [XYZ_dry{1},XYZ_dry{2},XYZ_dry{3}] = grid_and_loess_1st(bedprofile_corr,2,50,1,2,3);
end
    
if  switch_loess > 0
    if ~iscell(input_loess) || ( iscell(input_loess) && any (length(input_loess) == [1 4]) )
        XYZ_cb = cell(1,3);
        [XYZ_cb{1},XYZ_cb{2},XYZ_cb{3}] = grid_and_loess_1st(bedprofile_corr_cb,1,50,1,2,3);
    end
    if ~iscell(input_loess) || ( iscell(input_loess) && any (length(input_loess) == [1 4 7]) )
        if any(switch_loess == [2 3 5 6])
            XYZ_cb_2nd = cell(1,3);
            [XYZ_cb_2nd{1},XYZ_cb_2nd{2},XYZ_cb_2nd{3}] = grid_and_loess_2nd(XYZ_cb{1},XYZ_cb{2},XYZ_cb{3},0.002,1,5,2);
        end
    end
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

if switch_loess == 0 || switch_loess >= 4
    
% make an estimate of y-coordinate for submerged bedform data (needed
% because submerged bedform data contains a lot of NaNs)

    XI_cb_org = repmat(bedprofile_corr_cb{1}(:,1)',nbeams,1);
    YI_cb_org = bedprofile_corr_cb{1}(:,4:nbeams+3)';
    VI_cb_org = bedprofile_corr_cb{1}(:,nbeams+4:end)';

    YI_cb_org_estimate(:,1:nend_track(1)) = repmat(nanmean(YI_cb_org(:,1:nend_track(1)),2),1,nend_track(1));
    YI_cb_org_estimate(:,nend_track(1)+1:nend_track(2)) = repmat(nanmean(YI_cb_org(:,nend_track(1)+1:nend_track(2)),2),1,nend_track(2)-nend_track(1));
    YI_cb_org_estimate(:,nend_track(2)+1:nend_track(3)) = repmat(nanmean(YI_cb_org(:,nend_track(2)+1:nend_track(3)),2),1,nend_track(3)-nend_track(2));
    YI_cb_org_estimate(:,nend_track(3)+1:nend_track(4)) = repmat(nanmean(YI_cb_org(:,nend_track(3)+1:nend_track(4)),2),1,nend_track(4)-nend_track(3));
    
% find nearest neighbours using k,d-tree (to get bed level at every
% measurement location - needed because submerged data contains a lot of
% NaNs). To do so, the matrices are reshaped to vector form.
    
    index_NN = knnsearch([reshape(XYZ_dry{1},[],1) reshape(XYZ_dry{2},[],1)],[reshape(XI_cb_org,[],1) reshape(YI_cb_org_estimate,[],1)]);

    VI_dry_vector = reshape(XYZ_dry{3},[],1);
    VI_cb_org_ref_vector = nan(size(reshape(VI_cb_org,[],1)));

    for i=1:length(index_NN)
        VI_cb_org_ref_vector(i) = VI_dry_vector(index_NN(i));
    end
    VI_cb_org_ref = reshape(VI_cb_org_ref_vector,size(VI_cb_org));

end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

for b=1:length(lower_range_bins_z)
    lower_range_bins_z(b) = z_min + (b-1)*(z_max-z_min)/(bins_z-2);
end
for bb=1:length(lower_range_bins_epsilon)
    lower_range_bins_epsilon(bb) = epsilon_min + (bb-1)*(epsilon_max-epsilon_min)/(bins_epsilon-2);
end

if switch_loess == 0 || switch_loess >= 4
    counter = counter + 1;
    p_scat{counter} = nan(bins_z,bins_epsilon);
    p_nan{counter} = nan(bins_z,1);
    elements_nan{counter} = nan(bins_z,1);
    elements_scat{counter} = nan(bins_z,bins_epsilon);
    elements_total{counter} = nan(bins_z,1);
    elements_total_nonan{counter} = nan(bins_z,1);
    
    for b=1:bins_z
        if b==1
            ind_z = find(-VI_cb_org_ref<lower_range_bins_z(b));
        elseif b==bins_z
            ind_z = find(-VI_cb_org_ref>=lower_range_bins_z(b-1));
        else
            ind_z = find(-VI_cb_org_ref>=lower_range_bins_z(b-1) & -VI_cb_org_ref<lower_range_bins_z(b));
        end
       
        ind_z(ind_z<=144*17253) = [];
        ind_z_nonan = ind_z;
        ind_z_nonan(isnan(VI_cb_org(ind_z))) = [];

        elements_nan{counter}(b) = numel(find(isnan(VI_cb_org(ind_z))));
        elements_total{counter}(b) = numel(VI_cb_org(ind_z));
        if elements_total{counter}(b) ~= 0
            p_nan{counter}(b) = elements_nan{counter}(b)/elements_total{counter}(b);
        else
            p_nan{counter}(b) = 0;
        end
        
        elements_total_nonan{counter}(b) = numel(VI_cb_org(ind_z_nonan));
        for bb=1:bins_epsilon
            if bb==1
                ind_eps = find(-VI_cb_org(ind_z_nonan)+VI_cb_org_ref(ind_z_nonan)<lower_range_bins_epsilon(bb));
            elseif bb==length(lower_range_bins_epsilon)+1
                ind_eps = find(-VI_cb_org(ind_z_nonan)+VI_cb_org_ref(ind_z_nonan)>=lower_range_bins_epsilon(bb-1));
            else
                ind_eps = find(-VI_cb_org(ind_z_nonan)+VI_cb_org_ref(ind_z_nonan)>=lower_range_bins_epsilon(bb-1) & -VI_cb_org(ind_z_nonan)+VI_cb_org_ref(ind_z_nonan)<lower_range_bins_epsilon(bb));
            end        

            elements_scat{counter}(b,bb) = numel(VI_cb_org(ind_z_nonan(ind_eps)));
            if elements_total_nonan{counter}(b)~=0
                p_scat{counter}(b,bb) = elements_scat{counter}(b,bb)/elements_total_nonan{counter}(b);
            else
                p_scat{counter}(b,bb) = 0;
            end
        end
    end
end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

if switch_loess ~= 0
    counter = counter + 1;
    p_scat{counter} = nan(bins_z,bins_epsilon);
    p_nan{counter} = nan(bins_z,1);
    elements_nan{counter} = nan(bins_z,1);
    elements_scat{counter} = nan(bins_z,bins_epsilon);
    elements_total{counter} = nan(bins_z,1);
    elements_total_nonan{counter} = nan(bins_z,1);
    
    for b=1:bins_z
        if b==1
            ind_z = find(-XYZ_dry{3}<lower_range_bins_z(b) & XYZ_cb{2} > 730);
        elseif b==length(lower_range_bins_z)+1
            ind_z = find(-XYZ_dry{3}>=lower_range_bins_z(b-1) & XYZ_cb{2} > 730);
        else
            ind_z = find(-XYZ_dry{3}>=lower_range_bins_z(b-1) & -XYZ_dry{3}<lower_range_bins_z(b) & XYZ_cb{2} > 730);
        end
        
        ind_z_nonan = ind_z;
        ind_z_nonan(isnan(XYZ_dry{3}(ind_z))|isnan(XYZ_cb{3}(ind_z))) = [];
        
        elements_nan{counter}(b) = numel(find(isnan(XYZ_cb{3}(ind_z))));
        elements_total{counter}(b) = numel(XYZ_cb{3}(ind_z));
        if elements_total{counter}(b) ~= 0
            p_nan{counter}(b) = elements_nan{counter}(b)/elements_total{counter}(b);
        else
            p_nan{counter}(b) = 0;
        end
        
        elements_total_nonan{counter}(b) = numel(XYZ_cb{3}(ind_z_nonan));
        for bb=1:bins_epsilon
            if bb==1
                ind_eps = find(-XYZ_cb{3}(ind_z_nonan)+XYZ_dry{3}(ind_z_nonan)<lower_range_bins_epsilon(bb));
            elseif bb==length(lower_range_bins_epsilon)+1
                ind_eps = find(-XYZ_cb{3}(ind_z_nonan)+XYZ_dry{3}(ind_z_nonan)>=lower_range_bins_epsilon(bb-1));
            else
                ind_eps = find(-XYZ_cb{3}(ind_z_nonan)+XYZ_dry{3}(ind_z_nonan)>=lower_range_bins_epsilon(bb-1) & -XYZ_cb{3}(ind_z_nonan)+XYZ_dry{3}(ind_z_nonan)<lower_range_bins_epsilon(bb));
            end

            elements_scat{counter}(b,bb) = numel(XYZ_cb{3}(ind_z_nonan(ind_eps)));
            if elements_total_nonan{counter}(b)~=0
                p_scat{counter}(b,bb) = elements_scat{counter}(b,bb)/elements_total_nonan{counter}(b);
            else
                p_scat{counter}(b,bb) = 0;
            end
        end
    end
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

VI_bootstrap_nan_A = bootstrap_nan(N_bootstrap,p_nan{1},lower_range_bins_z,bedprofile_corr{2});
if counter > 1
    VI_bootstrap_nan_B = bootstrap_nan(N_bootstrap,p_nan{2},lower_range_bins_z,XYZ_dry{3},XYZ_dry{1},XYZ_dry{2});
else
    VI_bootstrap_nan_B = 0;
end

VI_bootstrap_ns_A = cell(N_bootstrap,4);
if counter > 1
    VI_bootstrap_ns_B = cell(N_bootstrap,3);
end
for i=1:N_bootstrap
    bedprofile_dummy = [bedprofile_corr{2}(:,1:147),VI_bootstrap_nan_A{i,2}];
    VI_bootstrap_ns_A(i,:) = bootstrap_scat(1,p_scat{1},lower_range_bins_z,epsilon_max,epsilon_min,bins_epsilon,bedprofile_dummy);
    if counter > 1
        VI_bootstrap_ns_B(i,:) = bootstrap_scat(1,p_scat{2},lower_range_bins_z,epsilon_max,epsilon_min,bins_epsilon,VI_bootstrap_nan_B{i,2},XYZ_dry{1},XYZ_dry{2});
    else
        VI_bootstrap_ns_B = 0;
    end
end

end



function VI_bootstrap = bootstrap_nan(N,pp,lower_range_z,bedprofile_dry,XI_dry,YI_dry)

ind_z = cell(length(lower_range_z),1);

if nargin == 4
    bedprofile = bedprofile_dry(:,148:end);
else
    bedprofile = bedprofile_dry;
end

ind_z{1} = -bedprofile < lower_range_z(1);
ind_z{end} = -bedprofile >= lower_range_z(end);
for b=2:length(lower_range_z)
    ind_z{b} = (-bedprofile >= lower_range_z(b-1) & -bedprofile < lower_range_z(b));
end

VI_bootstrap = nan_bootstrap(bedprofile,ind_z,pp,N);

% for nn=1:N
%     if nargin == 4
%         bedprofile_loess{1} = bedprofile_dry;
%         bedprofile_loess{1}(:,148:end) = VI_bootstrap{nn,2};
%         [VI_bootstrap{nn,3}{1},VI_bootstrap{nn,3}{2},VI_bootstrap{nn,3}{3}] = grid_and_loess_1st(bedprofile_loess,1,50,1,2,3);
%     else
%         [VI_bootstrap{nn,3}{1},VI_bootstrap{nn,3}{2},VI_bootstrap{nn,3}{3}] = grid_and_loess_2nd(XI_dry,YI_dry,VI_bootstrap{nn,2},0.002,1,5,2);
%     end
% end

end





function z_new = nan_bootstrap(z,ind_z,pp,N)

% z_new = cell(N,3);
z_new = cell(N,2);

for nn=1:N
    
    z_new{nn,1} = rng;
    dum_rand = rand(size(z)) + 1;
    z_new{nn,2} = z;
    for b=1:length(ind_z)
        num_rand = dum_rand.*ind_z{b};
        ind_nan = (num_rand<pp(b)+1 & num_rand>=1);
        dummy_nan = nan(size(ind_nan));
        dummy_nan(ind_nan~=1) = 0;
        z_new{nn,2} = z_new{nn,2} + dummy_nan;
    end
    
end

end






function VI_bootstrap = bootstrap_scat(N,pp,lower_range_z,epsilon_max,epsilon_min,bins_eps,bedprofile_dry,XI_dry,YI_dry)

ind_z = cell(length(lower_range_z)+1,1);

pp_sum = zeros(size(pp));
pp_sum(:,1) = pp(:,1);
for ip=1:size(pp,1)
    for jp=2:size(pp,2)
        pp_sum(ip,jp) = pp_sum(ip,jp-1) + pp(ip,jp);
    end
end

if nargin == 7
    bedprofile = bedprofile_dry(:,148:end);
else
    bedprofile = bedprofile_dry;
end

epsilon = nan(bins_eps,1);
delta_epsilon = (epsilon_max - epsilon_min)/(bins_eps-2);
for bb=1:bins_eps
        epsilon(bb) = epsilon_min - 0.5*delta_epsilon + (bb-1)*delta_epsilon;
end

ind_z{1} = -bedprofile < lower_range_z(1);
ind_z{end} = -bedprofile >= lower_range_z(end);
for b=2:length(lower_range_z)
    ind_z{b} = (-bedprofile >= lower_range_z(b-1) & -bedprofile < lower_range_z(b));
end

VI_bootstrap = epsilon_bootstrap(bedprofile,ind_z,epsilon,pp_sum,N);

for nn=1:N
    if nargin == 7
        bedprofile_loess{1} = bedprofile_dry;
        bedprofile_loess{1}(:,148:end) = VI_bootstrap{nn,2};
        [VI_bootstrap{nn,3}{1},VI_bootstrap{nn,3}{2},VI_bootstrap{nn,3}{3}] = grid_and_loess_1st(bedprofile_loess,1,50,1,2,3);
        [VI_bootstrap{nn,4}{1},VI_bootstrap{nn,4}{2},VI_bootstrap{nn,4}{3}] = grid_and_loess_2nd(VI_bootstrap{nn,3}{1},VI_bootstrap{nn,3}{2},VI_bootstrap{nn,3}{3},0.002,1,5,2);
    else
        [VI_bootstrap{nn,3}{1},VI_bootstrap{nn,3}{2},VI_bootstrap{nn,3}{3}] = grid_and_loess_2nd(XI_dry,YI_dry,VI_bootstrap{nn,2},0.002,1,5,2);
    end
end



end




function z_new = epsilon_bootstrap(z,ind_z,epsilon,pp,N)
                        
z_new = cell(N,3);
ind_eps = cell(length(epsilon),1);

for nn=1:N
    
    z_new{nn,1} = rng;
    dum_rand = 1+rand(size(z));
    z_new{nn,2} = z;
    for b=1:length(ind_z)
        for bb=1:size(ind_eps,1)
            ind_eps{bb} = zeros(size(z));
        end
        num_rand = dum_rand.*ind_z{b};
        ind_eps{1} = ind_eps{1} + (num_rand >= 1 & num_rand < pp(b,1)+1);
        ind_eps{end} = ind_eps{end} + (num_rand >= pp(b,end-1)+1);
        for bb=2:length(ind_eps)-1
            ind_eps{bb} = ind_eps{bb} + (num_rand >= pp(b,bb-1)+1 & num_rand < pp(b,bb)+1);
        end
        for bb=1:length(epsilon)
            z_new{nn,2} = z_new{nn,2} - (epsilon(bb).*ind_eps{bb});
        end
    end
end


end