%% Reading of data files and application of corrections for laser scans without water and with standing water.

sediment_switch = 'sandbed'; % 'none' or 'sandbed'
fig_switch = 1;
z_pos =400;

file_path_dry = 'SCANS/OF/DRY/FLUME/BOTTOM.%d.dat';
files_dry = [0:9];
                        
StartOfSwipes = [1 752 1503 2254]+50; % row number in input file for 'Correctie_withoutwater' where a new swipe starts (or where you want it to start)
EndOfSwipes = [751 1502 2253 3003]-50;

global ZR550 L_laser_camera refraction_index y_measure;

ZR550 = (550 - z_pos) + 451.7; % measured distance H (mm) between bottom of flume and focal point of laser (at y-location specified by y_measure)
y_measure = 500;
L_laser_camera = 175; % measured distance L (mm) between laser and camera
refraction_index = 1.33; % refraction index of water devided by refraction index of air

%%%% only needed in case 'sandbed' %%%%
xx = [1.7,3.7,6,8.3,11.3];
h = [261.05,261.05,261.05,261.05,261.05]; % water level
z0 = 258.1; zero reading of water level sensors
x0 = 0; hinging point of tilting flume
S0 = 0; flume bottom slope
Mlist = ZR550 - h + z0 + (xx - x0)*S0; distance M between sensor and water surface

directory_input = 'DIRECTORY/WITH/FILES/OF/SCANS';
range = {1,2,3}; % file numbers of data files in directory_input to read for 'sandbed' case
ind_dry = [1]; % the items in the list 'range' measured under dry-bed conditions
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% AE_fit = [0 0 0]; % option to manually set calibration parameters instead of calculating them each time as below
% coef = [0 0 0];
[withoutwater,zwithoutwater] = Inlezen_withoutwater_vs550_real(file_path_dry,files_dry,1);
[nowater_a,AE,coef,AE_fit,nowater_a_original] = Correctie_withoutwater_real(zwithoutwater,fig_switch,0,StartOfSwipes,EndOfSwipes);
% optional arguments:   1) degree (degree of polynomial for flume bottom fitting); default 2
%                       2) degreeAE (degree of polynomial for residual error fitting); default 2
%                       3) skip_in_AE_fit (number of lines from flume wall to skip (in first and last swipe); default [15 15]                 

switch sediment_switch
    case 'sandbed'
        [bedprofile,names] = Inlezen_sandbed_1tot99_real(directory_input, range, 0);
%         [bedprofile,names,middle_y,low_water_backup] = Inlezen_sandbed_1tot99_vary(directory_input, range, [80 81], 1);
%         [bedprofile,names,~,~] = Inlezen_sandbed_1tot99(directory_input, range);
        [bedprofile_corr] = Refractie_correctie_sandbed_1tot99(coef,AE_fit,Mlist,xx,bedprofile,ind_dry);

% if scanning of all swipes is in one direction (so only with increasing x), include these lines before plotting (probably change numbers to define row-bounds of second and fourth swipe):
%         bedprofile_corr{1}(17253:end,:) = flipud(bedprofile_corr{1}(17253:end,:));
%         bedprofile_corr{1}(17254:end,:) = flipud(bedprofile_corr{1}(17254:end,:));
%%%%%%
        X = cell(size(bedprofile_corr));
        Y = X;
        val = X;
        XI = X;
        YI = X;
        VI = X;
        for i=1:length(bedprofile_corr)
            bedprofile_corr{i}(:,148:end) = -bedprofile_corr{i}(:,148:end);
%%%%%%%%%%%%optional: set boundaries to define outliers
%             z_dum = bedprofile_corr{i}(:,148:end);
%             z_dum(z_dum<=0 & z_dum>=350) = NaN;
%             bedprofile_corr{i}(:,148:end) = z_dum;
            clearvars z_dum
            X{i} = zeros(size(bedprofile_corr{i},1),144);
            for j=1:144
                X{i}(:,j) = bedprofile_corr{i}(:,1)/1000;
            end
            Y{i} = bedprofile_corr{i}(:,4:147)-368.2; % value of 368.2 to shift min(y) to 0
            val{i} = bedprofile_corr{i}(:,148:291);
            figure;
            fig{i} = pcolor(X{i},Y{i},val{i});
            set(fig{i},'LineStyle','none');
            set(gca,'ticklabelInterpreter','latex');
            axis([3 8 0 1000]) % set [min(x) max(x) min(y) max(y)]
            h = colorbar;
            set(h,'ticklabelinterpreter','latex');
            ylabel(h,'$z\ (\mathrm{mm})$','interpreter','latex');
            caxis([-550 -400]); % set limits colorbar
            xlabel('$x\ (\mathrm{m})$','interpreter','latex');
            ylabel('$y\ (\mathrm{mm})$','interpreter','latex');
        end
        
% option for applying LOESS algorithm to measured bed profile
%         for i=1:length(bedprofile_corr)
%             [XI{i},YI{i},VI{i}] = grid_and_loess(0,4,0,bedprofile_corr,i,0,350,0.00002/2.5,1,2,1,12,8);
%         end

end