function [bedprofile] = Refractie_correctie_sandbed_1tot99_real(coef,AET_fit,Mlist,xx,bedprofile,ind_dry,ymid)

% ymid is the y-coordinate of the optical middle of the camera, determined
% manually (e.g. sawtooth-profile in water with different z of camera,
% determine heigths of peaks, fit trough location of peaks, find minimum of
% parabola)

global ZR550 y_measure L_laser_camera refraction_index;

% coef=[-5.68731526467640e-06 0.00537381632420911 342.108235059214];
% Mlist=[241.89, 243.10,  246.95, 247.86, 253.13, 255.99, 261.33, 262.57]; % Assumption M is constant over time and width of the flume
% xx=[1500,3000,4500,6000,7500,9000,10500,12000];

for ii=1:length(bedprofile)

M = NaN(size(bedprofile{ii},1),1);

% Interpolate M
for i=1:size(bedprofile{ii},1)
    for k=1:length(xx)
        if k==1 || k==length(xx)
            M(i) = Mlist(1);
        else
            M(i) = (Mlist(k) - Mlist(k-1)) / (xx(k) - xx(k-1)) * (bedprofile{ii}(i,1) - xx(k-1)) + Mlist(k-1);
        end
    end
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Delete outer 5 rows
%%%%%%%%%%%%%%%%%%%%%%%%%%%

bedprofile{ii}(:,[307:311 153:162 4:8])=[];

%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Set to the real depth
%%%%%%%%%%%%%%%%%%%%%%%%%%%

bodem_500 = coef(1)*y_measure.^2 + coef(2)*y_measure + coef(3);
%bodem=coef(1)*nowater(:,4:147).^2+coef(2)*nowater(:,4:147)+coef(3);
bod = bodem_500 + ZR550; %343.4312+448.9=792.3312
%real_bodem=bod-bodem;
%plot(nowater(:,4:147),-real_bodem,'.r')
z_bodem = bod-bedprofile{ii}(:,148:291);
bedprofile{ii}(:,148:291) = z_bodem;

%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Adjusting for relative transverse distance
%%%%%%%%%%%%%%%%%%%%%%%%%%%

% AET_fit=[9.96291339919777e-06 0.00153170735648420 0.0172461804415113];
y_stil_per(:,1) = bedprofile{ii}(:,2) + ymid;
fwy = bedprofile{ii}(:,4:147);
for i=1:size(fwy,2)
    y_stil_per(:,i)=y_stil_per(:,1);
end
diff_y_all = fwy-y_stil_per;
corrected_AET = AET_fit(1)*diff_y_all.^2 + AET_fit(2)*diff_y_all + AET_fit(3);
corrected_z_AET = bedprofile{ii}(:,148:291) + corrected_AET;
bedprofile{ii}(:,148:291) = corrected_z_AET;

%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Refraction Calculation
%%%%%%%%%%%%%%%%%%%%%%%%%%%

if ~ismember(ii,ind_dry)

fwz = bedprofile{ii}(:,148:291);
LL = sqrt(L_laser_camera^2+(diff_y_all).^2);

Ti = zeros(size(fwz,1),size(fwz,2));
Tr = zeros(size(fwz,1),size(fwz,2));
D_all = zeros(size(fwz,1),size(fwz,2));
c = zeros(size(fwz,1),size(fwz,2));
z_real_bed = zeros(size(fwz,1),size(fwz,2));

Mi = 0;
for i=1:size(fwz,1)
    if mod(i-1,size(bedprofile{ii},1))==0
        Mi = Mi+1;
    end
    for j=1:size(fwz,2)     
        Ti(i,j) = atand(LL(i,j)/fwz(i,j));
        Tr(i,j) = asind((sind(Ti(i,j)))/refraction_index);
        D_all(i,j) = ((fwz(i,j) - M(Mi)) * tand(Ti(i,j))) / tand(Tr(i,j));
        c(i,j) = D_all(i,j) - fwz(i,j) + M(Mi);
        z_real_bed(i,j) = fwz(i,j) + c(i,j);
        bedprofile{ii}(i,j+147) = z_real_bed(i,j);
    end
end

end

clearvars -except coef AET_fit Mlist xx bedprofile ii ZR550 y_measure L_laser_camera refraction_index ind_dry

end

end