function [withoutwater, zwithoutwater,C] = Inlezen_withoutwater_vs550_real(filenameGeneric,NumFiles,YREVERSE)

if nargin < 3 || isempty(YREVERSE)
    YREVERSE = 0;
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Inlezen no water
%%%%%%%%%%%%%%%%%%%%%%%%%%%

iimax = NumFiles(end)+1;

withoutwater = cell(1,numel(NumFiles));

% for ii=991:2:iimax
for nn=1:numel(NumFiles)
    
ii=NumFiles(nn)+1;

filename = sprintf(filenameGeneric,ii-1);
d = fopen(filename,'r');

lines = 0;
while ~feof(d)
    fgetl(d);
    lines = lines+1;                        % determine number of lines in file
end
frewind(d)

% Skip headerlines
for n=1:15
  fgetl(d);
end

m = 1;

A = struct('data',zeros(lines-n,1));                      % preallocate data structure

for m=1:lines-n
  tline = fgetl(d);
  A(m).data = tline;
end
fclose(d);

C = reshape(struct2cell(A),m,1);            % present data in cell array
C(size(C,1),:)=[];                          % remove last (empty!) row of C
Y = regexp(C,'\t','split');                 % split data in 1004x1 cell array of 1x619 cell arrays
Y=vertcat(Y{:});                            % present data in 1004x619 cell array
XX=Y;
Y(:,1:4)=[];
Y(:,find(all(cellfun(@isempty,Y),1))) = []; %delete whole empty column

S = strrep(sprintf('%s ', Y{:}),',','.');
Z = sscanf(S, '%f');
Z=reshape(Z,size(Y));
no_water=cell2mat({Z});                     % convert cell array to ordinary array (of floating point variables)

XX=XX(:,1);
XXX=regexp(XX, '\d+', 'match');
for m=1:size(XXX,1)
    for j=1:size(XXX{m},2)
        XX550(m,j)=XXX{m}(j);
    end
end
% time=XX550(:,1:4);
XX550(:,1:4)=[];
S = strrep(sprintf('%s ', XX550{:}),',','.');
Z = sscanf(S, '%f');
K=zeros(size(Y,1),3);
Z=reshape(Z,size(K));

no_water(no_water<=0) = NaN;

no_water=[Z no_water];

% Corrected for y
for i=1:size(no_water,1)
    for j=4:157
        no_water(i,j)=no_water(i,j)+no_water(i,2);
    end
end
if YREVERSE==1
    no_water(:,4:157) = fliplr(no_water(:,4:157));
end

if nn==1
    dummy = zeros(iimax,size(no_water,1),size(no_water,2));
end

dummy(nn,:,:) = no_water;
withoutwater{nn} = no_water;

clearvars -except ii nn withoutwater dummy NumFiles filenameGeneric Y S YREVERSE

end

%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Averaging the 10 dataswipes
%%%%%%%%%%%%%%%%%%%%%%%%%%%

% zwithoutwater = nan(size(withoutwater{1}));
zwithoutwater = squeeze(nanmean(dummy(nn,:,:),1));

clear ii i j dummy;

end