function [bedprofile,names,middle_y,low_water_backup] = Inlezen_sandbed_1tot99_real(directory,range,YREVERSE)

if nargin < 3 || isempty(YREVERSE)
    YREVERSE = 0;
end

% directory = '~/Documents/education/students/Susan_Dinnissen/Roughness_week_Susan_renamed';
readdir = dir(directory);

if nargin==1
    range = [length(readdir)-6 length(readdir)-6];
elseif isa(range,'double')
    names = cell(1,range(2)-(range(1)-1));
    for i=1:length(names)
        names{i} = readdir(range(1)+2).name;
    end
elseif isa(range,'cell')
    names = cell(size(range));
    for i=1:length(names)
        names{i} = readdir(range{i}+2).name;
    end
end

% directory = '~/Desktop/writing_week/matlab';
% names = {'r75_end.002.dat'};


bedprofile = cell(1,length(names));

%%%%%%%%%%%%%%%%%%%%%%%%%%%

for ii=1:length(names)

d = fopen(sprintf('%s/%s',directory,names{ii}),'r');

lines = 0;
while ~feof(d)
    fgetl(d);
    lines = lines+1;                        % determine number of lines in file
end
frewind(d)


% Skip headerlines
for n=1:15
    fgetl(d);
end

m = 1;
A = struct('data',zeros(lines-n,1));        % preallocate data structure

for m=1:lines-n
  tline = fgetl(d);
  A(m).data = tline;
end
fclose(d);
clearvars d

C = reshape(struct2cell(A),m,1);
clearvars A
C(size(C,1),:)=[];
Y = regexp(C,'\t','split');
clearvars C
Y=vertcat(Y{:});
XX=Y;
Y(:,1:4)=[];
Y(:,find(all(cellfun(@isempty,Y),1))) = []; %delete whole empty column

S = strrep(sprintf('%s ', Y{:}),',','.');
Z = sscanf(S, '%f');
clearvars S
Z=reshape(Z,size(Y));
low_water=cell2mat({Z});
clearvars Z filename delimiter formatSpec m n startRow tline

XX=XX(:,1);
XXtry=regexp(XX, ' ', 'split');
% time = zeros(size(XXtry,1),1);
for m=1:size(XXtry,1)
%     for j=1:size(XXtry{m},2)
        time(m,1)=XXtry{m}(1);
%     end
end
% time=time(:,1);
XXX=regexp(XX, '\d+', 'match');
for m=1:size(XXX,1)
    for j=1:size(XXX{m},2)
        XX550(m,j)=XXX{m}(j);
    end
end
XX550(:,1:4)=[];
S = strrep(sprintf('%s ', XX550{:}),',','.');
Z = sscanf(S, '%f');
K=zeros(size(Y,1),3);
Z=reshape(Z,size(K));

low_water(low_water<=0)=NaN;

low_water = [Z low_water];

% Corrected for y
for i=1:size(low_water,1)
    for j=4:157
        low_water(i,j)=low_water(i,j)+low_water(i,2);
    end
end
if YREVERSE==1
    low_water(:,4:157) = fliplr(low_water(:,4:157));
end

bedprofile{ii} = low_water;

clearvars XX XXX XX550 Z Y K i j m zero z outliers idx r75_1_z ans time S

end

end