function [nowater_a,AE,coef,AE_fit,nowater_a_original] = Correctie_withoutwater_real(nowater_a_original,fig_switch,raw,aa,bb,degree,degreeAE,skip_in_AE_fit)

% Note: apparently aa(1)=1 gives strange results (not clear if this is
% general). Better skip it.

global ZR550 y_measure;

XMIN = 1000;%1100;
XMAX = 1750;%1175;
ymid = 77;

if nargin<6 || isempty(degree)
    degree = 2; % degree of flume bottom polynomial
end
if nargin<7 || isempty(degreeAE)
    degreeAE = 2; % degree of polynomial for residual error fitting
end
if nargin<8 || isempty(skip_in_AE_fit)
    skip_in_AE_fit = [15 15]; %[11 7]; % values to skip from flume boundaries (first and last swipe)
end

num_swipes = length(aa);

%%%%%%%%%%%%%%%%%%%%%%%%%%% 
% Check Profile nowater_a without correction or anything
%%%%%%%%%%%%%%%%%%%%%%%%%%% 

def_colors = get(groot,'DefaultAxesColorOrder');
colors_swipes = nan(num_swipes,3);
for i=1:num_swipes
    colors_swipes(i,:) = def_colors(mod(i,size(def_colors,1))+1,:);
end

if raw==1

% First delete last and first five columns
nowater_a=nowater_a_original;
nowater_a(:,[307:311 153:162 4:8])=[];

    if fig_switch==1
        figure;
        plot(nowater_a(aa(1):bb(1),4:147),nowater_a(aa(1):bb(1),148:291),'.b')
        if num_swipes>1
            hold on
            for i=2:num_swipes
                plot(nowater_a(aa(i):bb(i),4:147),nowater_a(aa(i):bb(i),148:291),'.b')
            end
        end
        title('Profile measured without water')
        xlabel('Transverse Distance Y (mm)')
        ylabel('Measured Heigth (mm)')
        hold off
    end

else
    
if aa(1)>1
    nowater_a_original(1:aa(1)-1,:) = -9999;
end
if bb(end)<size(nowater_a_original,1)
    nowater_a_original(bb(end):end,:) = -9999;
end
for ss = 1:num_swipes-1
    if diff([bb(ss) aa(ss+1)])>1
        nowater_a_original(bb(ss)+1:aa(ss+1)-1,:) = -9999;
    end
end
nowater_a_original(all(nowater_a_original==-9999,2),:) = [];

%%%%%%%%%%%%%%%%%%%%%%%%%%%    
% Check for the real depths
%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Delete the outermost data
nowater_a=nowater_a_original;
nowater_a(:,[307:311 153:162 4:8])=[];

nowater_a(nowater_a(:,1)>XMAX,:)=[];
nowater_a(nowater_a(:,1)<=XMIN,:)=[];
nowater_a_fit = nowater_a;
nowater_a_fit(any(isnan(nowater_a_fit(:,ymid)),2),:)=[];

coef=polyfit(nowater_a_fit(:,ymid),nowater_a_fit(:,ymid+144),degree);

    if fig_switch==1
        figure;
        xline=linspace(nanmin(nanmin(nowater_a(:,4:147))),nanmax(nanmax(nowater_a(:,4:147))),16483);
        yline=polyval(coef,xline);
        plot(xline,yline,'r.');
        hold on
        plot(nowater_a(:,ymid),nowater_a(:,ymid+144),'b.');
        title('Fit of the bottom of the flume and used data points')
        xlabel('Transverse Distance Y (mm)')
        ylabel('Measured Heigth (mm)')
        hold off
    end
    
nowater_a=nowater_a_original;
nowater_a(:,[307:311 153:162 4:8])=[];

%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Set to the real depth
%%%%%%%%%%%%%%%%%%%%%%%%%%%

bodem_500=0;
bodem = 0;
for i=1:degree+1
    bodem_500 = bodem_500 + coef(i)*y_measure^(degree+1-i); % coef(1)*y_measure^2+coef(2)*y_measure+coef(3);
    bodem = bodem + coef(i)*nowater_a(:,4:147).^(degree+1-i); % coef(1)*nowater_a(:,4:147).^3+coef(2)*nowater_a(:,4:147).^2+coef(3)*nowater_a(:,4:147)+coef(4);
end
bod=bodem_500+ZR550; %343.4312+448.9=792.3312
real_bodem=bod-bodem;
z_bodem=bod-nowater_a(:,148:291);
nowater_a(:,148:291)=z_bodem;

fprintf('a = [%.4e; %.4e; %.4e]\n',coef(1),coef(2),coef(3)-bod);

    if fig_switch==1
        figure;
        hold on;
        for i=1:num_swipes
            if i==1
                numaabb = diff([aa(1) bb(1)]);
                plot(nowater_a(1:numaabb,4:147),-nowater_a(1:numaabb,148:291),'.','color',colors_swipes(i,:),'markersize', 1)
            else
                plot(nowater_a(numaabb+1:numaabb+diff([aa(i) bb(i)]),4:147),-nowater_a(numaabb+1:numaabb+diff([aa(i) bb(i)]),148:291),'.','color',colors_swipes(i,:),'markersize',1)
                numaabb = numaabb+diff([aa(i) bb(i)]);
            end
        end
        xlabel('Transverse Distance (mm)','FontSize',10)
        ylabel('z (mm)','FontSize',10)
        plot(nowater_a(:,4:147),-real_bodem,'.k')
        hold off

        figure;
        hold on;
        for i=1:num_swipes
            plot(nowater_a(:,4:147),-nowater_a(:,148:291),'.b','markersize', 1)
        end
        plot(nowater_a(:,4:147),-real_bodem,'.r')
        xlabel('Transverse Distance (mm)','FontSize',10)
        ylabel(' z (mm)','FontSize',10)
        hold off
    end

%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Calculate Absolute Error and Correct for the transverse error
%%%%%%%%%%%%%%%%%%%%%%%%%%%

AE=real_bodem-z_bodem;
nowater_flat=nowater_a;
findies=find(nowater_flat(:,1)>XMAX|nowater_flat(:,1)<=XMIN);
nowater_flat(findies,:)=[];
real_bodem_flat=real_bodem;
real_bodem_flat(findies,:)=[];
AE_flat=real_bodem_flat-nowater_flat(:,148:291);

y_stil_per_no = zeros(size(nowater_flat,1),1);
diff_y_no_flat = zeros(size(nowater_flat,1),144);

for i=1:size(nowater_flat,1)
    y_stil_per_no(i,:)=nowater_flat(i,2);%ymid);
    for j=1:144
        diff_y_no_flat(i,j)=nowater_flat(i,j+3)-y_stil_per_no(i);
    end
end

diff_y_no_flat2 = diff_y_no_flat;
if skip_in_AE_fit(1) >= 1
    diff_y_no_flat2(1:bb(1)-aa(1)+1,1:skip_in_AE_fit(1)) = NaN;
end
if skip_in_AE_fit(2) >= 1
    diff_y_no_flat2(end-(bb(end)-aa(end)):end,145-skip_in_AE_fit(2):144) = NaN;
end
% IN THE FOLLOWING, ONLY DATA OUTSIDE [a,b] ARE REMOVED FROM BEGINNING OF
% FIRST SWIPE AND ENDING OF LAST SWIPE (FOR PLOTTING REASONS: EXCLUDING
% EDGES IN PLOT 4)
% if aa(1)>=1
%     diff_y_no_flat2(1:aa(1),:) = NaN;
% end
% if bb(end)<=size(diff_y_no_flat2,1)
%     diff_y_no_flat2(bb(end):size(diff_y_no_flat2,1),:) = NaN;
% end
ind_noNan = ~(isnan(diff_y_no_flat2) | isnan(AE_flat));

AE_fit = polyfit(diff_y_no_flat2(ind_noNan),AE_flat(ind_noNan),degreeAE);

fprintf('b = [%.4e; %.4e; %.4e]\n',AE_fit(1),AE_fit(2),AE_fit(3));

    if fig_switch==1
        nowater_a_x = nowater_a(:,4:147);
        nowater_a_z = nowater_a(:,148:291);
        figure;
        plot(nowater_a_x(ind_noNan),-nowater_a_z(ind_noNan),'.b','markersize',1);
            
        figure;
        plot(diff_y_no_flat2(ind_noNan),AE_flat(ind_noNan),'.b','markersize', 1);
        hold on;
        diff_y_no_flat_fitted = zeros(size(diff_y_no_flat));
        for i=1:degreeAE+1
            diff_y_no_flat_fitted = diff_y_no_flat_fitted + AE_fit(i)*diff_y_no_flat.^(degreeAE+1-i);
        end
        diff_y_no_flat(isnan(diff_y_no_flat_fitted))=[];
        diff_y_no_flat_fitted(isnan(diff_y_no_flat_fitted))=[];
        plot(diff_y_no_flat,diff_y_no_flat_fitted,'-k'); % AE_fit(1)*diff_y_no_flat.^2+AE_fit(2)*diff_y_no_flat+AE_fit(3)
%         xlim([-250 250])
        xlabel('Relative Transverse Distance (mm)','FontSize',10)
        ylabel('Residual Error (mm)','FontSize',10)
        hold off
    end

diff_y_no = zeros(size(nowater_a,1),144);

for i=1:size(nowater_a,1)
    y_stil_per_no(i,:)=nowater_a(i,2);%ymid);
    for j=1:144
        diff_y_no(i,j)=nowater_a(i,j+3)-y_stil_per_no(i);
    end
end

corrected_AE = zeros(size(diff_y_no));
for i=1:degreeAE+1
    corrected_AE = corrected_AE + AE_fit(i)*diff_y_no.^(degreeAE+1-i); % AE_fit(1)*diff_y_no.^2+AE_fit(2)*diff_y_no+AE_fit(3);
end
corrected_z=nowater_a(:,148:291)+corrected_AE;



% Bring it all together in one matrix again
nowater_a(:,148:291)=corrected_z;           % now the residual error is incorporated in nowater_a

% Calculate residual fit
residual=real_bodem-nowater_a(:,148:291);

    if fig_switch==1
        figure;
        hold on;
        for i=1:num_swipes
            if i==1
                numaabb = diff([aa(1) bb(1)]);
                plot(nowater_a(1:numaabb,4:147),residual(1:numaabb,:),'.','color',colors_swipes(i,:),'markersize', 1)
            else
                plot(nowater_a(numaabb+1:numaabb+diff([aa(i) bb(i)]),4:147),residual(numaabb+1:numaabb+diff([aa(i) bb(i)]),:),'.','color',colors_swipes(i,:),'markersize',1)
                numaabb = numaabb+diff([aa(i) bb(i)]);
            end
        end
        xlabel('Transverse Distance (mm)','FontSize',10)
        ylabel('Residual Error (mm)','FontSize',10)
        hold off
    end

end

end