function X = accrejrnd(f,g,grnd,c,n,lambda) 
% This function is the core of the acceptance-rejection method
% to generate random numbers that follow an arbitrary random variable.
%
% n is the total number of random samples to be generated. 
%
% Lambda has been added to support 'modGaussrnd_vec.m'.
               
X = zeros(n,1);     % Preallocate memory to speed up.

for i = 1:n 
    accept = false; 
    while accept == false 
        u = rand(); 
        v = grnd(); 
        if c*u <= f(v,lambda)/g(v) 
           X(i) = v; 
           accept = true; 
        end 
    end 
end 
