function fun_rhs=rhs_component_vec_adaptive(lambda_j,a_j,s)
%
% Update History
%
% 1. This is to vectorize the calculation. The function now accepts lambda_j 
% and a_j as vectors, while s should be a scalar.        Aug.7, 2011 
% 2. To increase the efficiency of the computatioin, a simple adaptive scheme
% has been applied. The parameters, 10^(-16), 100/lambda_j(k) and 1000, should 
% be examined one more time carefully, though.
% 3. The function name is changed from rhs_component_vec_test.m to 
% rhs_component_vec_adaptive.m. 

part1_vec = zeros(1,length(lambda_j));

for k=1:length(lambda_j)
    
    % Adaptive Scheme Depending on The Shape of The Modified Gaussian 
    % Distribution. The number of discretization has been set to 1000, but
    % the mesh length will change depending on lambda_j(k). Whether the
    % current number of discretization is close to the optimil value needs
    % a further investigation, which is important because trapz is sort of
    % a bottle neck. 

    if lambda_j(k) >= sqrt(pi^2/(-log(10^(-16))*2)); 
       % x = linspace(0,pi,ceil(1000/lambda_j(k)));
        x = 0:pi/(ceil(1000/lambda_j(k))-1):pi;
    else
        xmax = sqrt(-log(10^(-16))*2*lambda_j(k)^2);
        %x = linspace(0,xmax,1000);
        x = 0:xmax/(1000-1):xmax;
    end
    
	f1_real = cos(a_j(k)*s*cos(x)).*exp(-x.^2/(2*lambda_j(k)^2));   
	f1_imag = sin(a_j(k)*s*cos(x)).*exp(-x.^2/(2*lambda_j(k)^2));   

    % The use of the following lines is faster than the use of trapz.
    S1=0.5*sum((f1_real(1:end-1)+f1_real(2:end))*(x(2)-x(1)));
    S2=0.5*sum((f1_imag(1:end-1)+f1_imag(2:end))*(x(2)-x(1)));
    part1 = S1+1i*S2;
														    
%	part1 = trapz(x,f1_real)+1i*trapz(x,f1_imag);
    
	part1_vec(k) = part1;

end

part2 = pi*erf(pi./(lambda_j*sqrt(2))).*besselj(0,a_j*s);
part3 = pi*besselj(0,a_j*s);

g_n = sqrt(2*pi)./(pi*lambda_j).*part1_vec - 1/pi*part2 + 1/pi*part3;

fun_rhs=prod(g_n);        % g_n(1)*g_n(2)*g_n(3)*g_n(4)*...*g_n(N)

