function [OMEGA,PHASE,PDF] = ProcessRawPhases(omega,phase,TEValpha,j)

[OMEGA,PHASE]=meshgrid(omega,phase);
PDF=zeros(size(PHASE,1),size(PHASE,2));

% size(TEValpha)=[N MaxRuns]

% It is possible to remove the following for-loop using an
% array in 'N=hist(...,phase)'. But need to check if it
% is better in terms of the memory management.

for k=1:size(TEValpha,1)
	
	% N as a local variable is OK. But as a global variable,
    % it should be reserved for the number of Fourier Components.

    N=hist(TEValpha(k,:),phase);  
    
    % The following is to compensate 'the problem' that the width of bins 
    % associated with two ends is half of the other bins. 
    % Refer to 'help hist'.
    
    N(1)=N(1)*2;N(end)=N(end)*2;
    
    Area=0.5*sum((N(1:end-1)+N(2:end)).*(phase(2)-phase(1)));
    
    % Normalization of the Area to the Unity. 
    % PDF for each omega
   PDF(:,k) = N/Area;
   
end

figure(j)
surf(OMEGA,PHASE,PDF)

xlabel('$\omega [rad/sec]$','FontSize',12);
ylabel('$\epsilon [rad]$','FontSize',12);
zlabel('PDF','FontSize',12)
box on

