function new_alpha = prefilter(a,alpha,omega,n)
% Given a, epsilon, omega and t, this function checks if the response is
% at its maximum/minimum "around" t=0.

% This function has been upgraded for the multidirectional DLG.
% Feb. 4, 2013

t_test = -0.08:0.02:0.08;
x1_array = zeros(length(t_test),n);
omega_array = repmat(omega,[1,n]);  % size(omega_array) = (N*new_n)

% x1_array(j,:) = x1;  % size(x1_array) = (length(t), new_n)

for j=1:length(t_test)
    x1=0;
    for k=1:size(a,1)
        x1 = x1 + a(k,:)*cos(alpha(:,:,k)+omega_array*t_test(j));     % (1 x N) * (N, new_n) = (1, new_n)  --> construct this by repeating this
    end
    x1_array(j,:) = x1;  % size(x1_array) = (length(t), new_n)
end

[~,I] = max(x1_array,[],1);

mp=ceil(length(t_test)/2);  % midpoint

to_be_used=ismember(I,[mp-2 mp-1 mp mp+1 mp+2]);

new_alpha = alpha(:,to_be_used,:);