function [X]=modGaussrnd_vec(lambda,n)
% This function generate n random numbers that follow the modified Gaussian 
% distribution of the parameter lambda using the acceptance-rejection method. 
%
% Usage : [X]=modGaussrnd_vec(lambda,n)
%
%         where lamba is the parameter of the modified gaussian and n
%         is the desired number of samples. lambda should be a scalar.
%
% May, 2011 by DHK
%
% It is a vectorized version of the from the previous version, modGaussrnd.m

f = @(x,lambda) 1/(sqrt(2*pi)*lambda)*exp(-x.^2/(2*lambda^2)) + 1/(2*pi)*(1-erf(pi/(sqrt(2)*lambda)));
g = @(x) 1/(2*pi);   % 
grnd = @(m) -pi + 2*pi*rand(1,m);

c = 1.01*f(0,lambda)/g(0);         
X = accrejrnd_vec(f,g,grnd,c,n,lambda);  % size(X) = (n,1)

if length(X)>= n
	% if too many have passed the test
    X=X(1:n);  
else  
	% if too few have passed the test
    Xadd = accrejrnd_vec(f,g,grnd,c,100*c*(length(X)-n),lambda); 
    X=[X Xadd];
end

if length(X)>= n
    X=X(1:n);
else
    grnd_s = @() -pi + 2*pi*rand();

	% until you get the remaining number of random variable
    X_temp = accrejrnd(f,g,grnd_s,c,n-length(X),lambda);  
    X=[X X_temp'];
end
