function makeTransferFn(MphiK2,InputSpectrumPtR)

%%% frequency is a column vector
%%% MphiRV is a 2 column vector- 1st column is magnitude at given frequency, 
%%% 2nd column is phase vector (in degrees) associated with the given row frequency

z = MphiK2(:,1).*exp(1i.*MphiK2(:,2));

M = abs(z);
arg = angle(z)*180/pi; %phase should be in degrees going into DLG

frequency = InputSpectrumPtR(:,1);
fout1=[frequency M arg]';
temp_filename=fullfile('Inputs',strcat('TransferFunction.dat'));
fid1 = fopen(temp_filename,'wt');
fprintf(fid1,'%12.8f %22.6E %8.2f\r\n',fout1);
fclose(fid1);

end