function [Smax]=determineSmax(sigma,TEV,numfig)
% The functino is a modification of char_evPDf.m to calculate Smax, 
% or S_threshold, which will be used in many places of DLG. DHK.
%
% Version 1.01

if nargin == 2;
	numfig = 0;
end

xo=9*sigma;  % 9*sigma 

N=2^10;      % Number of Sampling Points
NFFT=2^15;   % Number of FFT points

% Causal Signal
x = linspace(0,xo,N); 

% This is only true when m -> infty. Any chance I can improve the accuracy?
m=round(1/(1-normcdf(TEV)));

signal= m*1/(sigma*sqrt(2*pi))*exp(-1/2*(x/sigma).^2).*(normcdf(x/sigma)).^(m-1);

dx=x(2) - x(1);   % analogous to dt
fs=1/(NFFT*dx);   % frequency resolution

f=fs*linspace(-NFFT/2,NFFT/2-1,NFFT);  % From -Fmax to Fmax-fs. NFFT points
 
% ----------------------------------- Approximation using Fourier Transform 
FT1=fft(signal,NFFT)*dx; 

% Due to the difference in the definition of characteristic function.
FT2=conj(FT1);  

% Negative frequency is also important due to imag portion.
FT=fftshift(FT2);  
s=2*pi*f;                           % Analogous to omega

% The array 's' always include zero, as long as NFFT is fixed. 
midindex=find(s==0);

% Find the first s>0 that's less than 0.01 and take it as Smax.

temp_i=find(abs(FT(midindex:end))<=0.01*max(abs(FT)),1);
index_for_Smax = midindex+temp_i-1;
Smax = s(index_for_Smax);

scale=[-Smax Smax -1 1];			

if numfig ~= 0
    
	figure(numfig);
	subplot(211)
	plot(s,real(FT)); axis(scale);
	%ylabel('Real(F(s))');grid on
    ylabel('Real(\Psi(s))','FontSize',12);grid on
	title(strcat('Characteristic Function of Gaussian EV Distribution: ', ...
				 '\sigma = ',num2str(sigma), ', TEV = ',num2str(TEV)))   
	subplot(212)
	plot(s,imag(FT)); axis(scale);
	%ylabel('Imag(F(s))');xlabel('s [rad/s]');grid on
    ylabel('Imag(\Psi(s))','FontSize',12);xlabel('s [rad/s]','FontSize',12);grid on

end
% -------------------------------------------------------------------------

