function [new_s, FT]=calculatePsi(a, lambda, TEV, TEV_shift, N_init, N_final, numfig)
% The function calculate Psi, and it can be used for the multidirectional 
% DLG. Therefore, the size of 'a' and 'lambda' should be (nh, N), where
% nh is the number of heading angles.
%
% Default Value: N_init = 2^8, N_final= 2^16

% If dx is needed, use the following two lines from the output of the
% function. 
%
% Fmax=-new_s(1)/(2*pi);
% dx=1/(2*Fmax);
% NFFT = length(FT)

if nargin == 4
    N_init = 2^8; 
    N_final= 2^16;
    numfig = 0;
end

% Number of Heading
nh=size(a,1);

ResponseRMS = sqrt(sum(1/2*sum(a.^2,2)));
Smax_orig = determineSmax(ResponseRMS,TEV,numfig);  % Original TEV

s_orig=linspace(0,Smax_orig,N_init);     
fun_rhs_part=ones(nh,N_init);  

for j=1:nh
    for k=1:length(s_orig)    
        fun_rhs_part(j,k) = rhs_component_vec_adaptive(lambda(j,:),a(j,:),s_orig(k));    
    end
end

fun_rhs_temp = prod(fun_rhs_part,1);

% Shift the approximated EV PDF to the target TEV
% e.g., The trasform of RHS_for_Initial to RHS_for_Target

fun_rhs=exp(1i*s_orig*TEV_shift*ResponseRMS).*fun_rhs_temp; 

% There is no right or wrong answer for the size of FT1.
FT1 = zeros(1,N_final);  

% The right hand side of the governing equation --- Effective zero padding 
FT1(1:length(fun_rhs))=fun_rhs;

% FT0: Symmetric Part of FT1
FT0 = zeros(1,N_final);
starting_point=length(FT0)-length(fun_rhs(end:-1:2))+1;
FT0(starting_point:end)=conj(fun_rhs(end:-1:2));

FT=[FT0 FT1];
NFFT = length(FT);

% New Fmax due to the zero padding 
ds=s_orig(2)-s_orig(1); 
df=ds/(2*pi);
Fmax = df*(NFFT/2); 
Smax = 2*pi*Fmax;     
dx=1/(2*Fmax);

% New vector 's' that goes with 'FT'
new_s=linspace(-Smax,Smax-ds,length(FT));

if numfig ~= 0
    
    % On top of the characteristic funtion of theoretical evPDF
    figure(numfig);  
    subplot(211);hold on
    plot(new_s,real(FT),'r');
    subplot(212);hold on
    plot(new_s,imag(FT),'r')
end