function [X, index] = accrejrnd_vec(f,g,grnd,c,n,lambda) 
% This function is the core of the acceptance-rejection method
% to generate random numbers that follow an arbitrary random variable.
%
% n is the total number of random samples to be generated. 
%
% Lambda has been added to support 'modGaussrnd_vec.m'.
%
% It is a vectorized version of the from the previous version, accrejrnd.m
% A new veriable index is returned to the script to be used to store the
% associated phase information.
% 
% Aug. 2011 by DHK

u=rand(1,ceil(c*n));
v=grnd(ceil(c*n));

index=find(c*u-f(v,lambda)./g(v) <= 0);
X=v(index);



