function DLGpost
% This function uses the acceptance-rejection method to filter the 
% approximated EV PDF found in the previous step.
%
% July 31, 2011
% By Daehyun Kim  

% Lots of changes has been made between July 31 an May 3, which are not
% documented here.

% May 3, 2012
% Additional 'filter' has been added before the acceptance-rejection
% method.

clear all;close all;clc

%
    %Generate additional LAMP_OPENFOAM directory per K. Maki's Nov. 13, 2015
    %email.  See lines 410-420 below    AWT Nov 16, 2015
%
mkdir('Outputs','LAMP_MAKI_inputs');
%
%
%

% The following line is necessary if DLGpost alone is executed later.

iseed = sum(1e5*clock);rand('twister',iseed);  

temp_filename=fullfile('Inputs','CaseParameters.dat'); 
[data, ~] = textread(temp_filename,'%f %s','headerlines',0);

NumCompIn = data(1);
N = data(2);
io = data(3);
fo = data(4);
MaximaOrMinima = data(5);
TEV = data(6);
CaseNumber = data(7);
Heading = data(8);
Velocity= data(9);
Gravity = data(10);
t0 = data(11);

if Heading == 1000
    temp_filename=fullfile('Inputs','WaveHeadings.dat');
    WaveHeadings=load(temp_filename);
    NumWaveHeadings=length(WaveHeadings);
else
    NumWaveHeadings=1;
    WaveHeadings=Heading;
end

m=round(TEVtoNumberOfSamples(TEV));
[Char_CaseNo]=generateConsistentCharNumber(CaseNumber,3);

a=zeros(NumWaveHeadings,N);
a_excitation=zeros(NumWaveHeadings,N);
TransferPhase=zeros(NumWaveHeadings,N);
ResponseVar = 0;

if NumWaveHeadings == 1
       a(1,:)=load(fullfile('Inputs',strcat('a.dat')));   
       a_excitation(1,:)=load(fullfile('Inputs',strcat('a_excitation.dat')));
       TransferPhase(1,:)=load(fullfile('Inputs',strcat('TransferPhase.dat')));
       ResponseVar = 1/2*sum(a(1,:).^2); 
else
    for k=1:NumWaveHeadings
       a(k,:)=load(fullfile('Inputs',strcat('a',num2str(k),'.dat')));
       a_excitation(k,:)=load(fullfile('Inputs',strcat('a_excitation',num2str(k),'.dat')));
       TransferPhase(k,:)=load(fullfile('Inputs',strcat('TransferPhase',num2str(k),'.dat')));
       ResponseVar = ResponseVar + 1/2*sum(a(k,:).^2);
    end
end

ResponseRMS=sqrt(ResponseVar);
omega = load(fullfile('Inputs','omega.dat'));  % same for all headings

% temp_filename1=fullfile('Outputs',strcat('NewLambdasCase',Char_CaseNo,'.dat')); 
% raw1=load(temp_filename1);
% lambda=raw1(:,2);
% 
% temp_filename3=fullfile('Inputs','a.dat'); 
% raw3=load(temp_filename3);
% a=raw3; a=a';                         % make it a horizontal vector

lambda=zeros(NumWaveHeadings,N);

if NumWaveHeadings == 1
        temp_data = load(fullfile('Outputs',strcat('NewLambdasCase',Char_CaseNo,'.dat')));
        lambda(1,:)=temp_data(:,2);
else
    for k=1:NumWaveHeadings
        temp_data = load(fullfile('Outputs',strcat('NewLambdasCase',Char_CaseNo,'a',num2str(k),'.dat')));
        lambda(k,:)=temp_data(:,2);
    end
end

filename=strcat('TheConstantCforARmethod',Char_CaseNo,'.dat');
TheConstantC_filename=fullfile('Outputs',filename); 

[~, data] = textread(TheConstantC_filename,'%s %f','headerlines',0);
c = data(1);

disp(' ')
n = input('# of realizations (n) for the comparison of the extreme value PDF? ');

f_ev=@(x) m*1/(sqrt(2*pi))*exp(-1/2*x.^2).*normcdf(x).^(m-1);
F_ev=@(x) normcdf(x).^(m);

new_n=round(1.1*c*n);  % 110% of the expected number of required random numbers.
NumBinsX=ceil(sqrt(n))/2;          % let's check Dave's suggestion....

if NumBinsX >= 75
   NumBinsX = 75; 
end

filename=strcat('evPDFrawCase',Char_CaseNo,'.dat');
evPDF_filename=fullfile('Outputs',filename); 

[x_center,x_PDF] = textread(evPDF_filename,'%f %f','headerlines',1);
F_gY = (x_center(2)-x_center(1))*cumtrapz(x_PDF);

%%
tic     % time clock on 

alpha = zeros(N,new_n,NumWaveHeadings);

%%
% The following block will work if the filter is not required.
% looping over omega_n

% for k=1:N
%     
%    for kk=1:NumWaveHeadings
%       alpha(k,:,kk)=modGaussrnd_vec(lambda(kk,k),new_n); 
%    end
%    
% end

%%
% This block should be used if the filter is required.
%
% Prepare the candidates before the acceptance-rejection method. The
% prefilter is being prepared to find the sets of phases of which extreme
% responses will happen at the very vicinity of t=0. 

alpha_collect=[];

while size(alpha_collect,2) < new_n

   % looping over omega_n
    for k=1:N
        for kk=1:NumWaveHeadings
            alpha(k,:,kk)=modGaussrnd_vec(lambda(kk,k),new_n); 
        end
    end
    
    % filter to enforce the condition of the 1st and 2nd derivative.
    new_alpha = prefilter(a,alpha,omega,size(alpha,2)); 
    alpha_collect = [alpha_collect new_alpha];
    
end
    
alpha=alpha_collect;

% bin_phase_for_visualization=linspace(-pi,pi,25);
% [OMEGA1,PHASE1,PDF1]=processRawPhases(omega',bin_phase_for_visualization,alpha_raw,7);
% [OMEGA2,PHASE2,PDF2]=processRawPhases(omega',bin_phase_for_visualization,alpha,8);
% 
% figure(9)
% surf(OMEGA1,PHASE1,PDF1-PDF2)

%%

new_n=size(alpha,2);  % with filter
x1=zeros(1,new_n);

for iWaveHeading=1:NumWaveHeadings
        x1=x1+a(iWaveHeading,:)*cos(alpha(:,:,iWaveHeading));  % (1 x N) * (N x new_n)
end

x1=x1/ResponseRMS;      % normalized response

    
%A slight change in g_Y is observed when the filter is applied. This may affect 
%the acceptance-rejection algorithm in the next cell. A futher
%improvement can be made with regard to the filter in the future version.

[Fx1,x1_emp]=ecdf(x1);

% figure(998)
% subplot(121)
% plot(x1_emp,Fx1,x_center,F_gY);title('Comparison Before A-R Process')
% subplot(122)
% hist(x1,NumBinsX);hold on;
% [N_in_bin, bin_center]=hist(x1,NumBinsX);
% plot(x_center,x_PDF*new_n*(bin_center(2)-bin_center(1)))


%% Start the post-processing (i.e., the acceptance-rejection method)

disp(' ')
disp({'The Acceptance-Rejection procedure has started.'})

x1_processed = zeros(n,1);   % filtered x1
index_chosen = zeros(n,1);
    
accept = false; i=1; counter=1;      % to see if it reached the required phase numbers   

while accept == false || i < new_n   % check if can be accepted
    
    if counter == n+1
       break 
    end
    
    u = rand();
    v = x1(i);                       % This line works as a random # generator.
    g_v=interp1(x_center,x_PDF,v);   % I need a slightly different g_v, if the filter
                                     % is applied.
        
    if c*u <= f_ev(v)/g_v 
           x1_processed(counter) = v; 
           index_chosen(counter) = i;
           
         % When this line is triggered for the first time, the counter is 2.  
           
           counter = counter+1;
           accept  = true;
    end
    
    i=i+1  ;
end

% I don't think this will happen. But let's leave it, just in case.

if counter < n
    x1_processed = x1_processed(1:counter-1);
    index_chosen = index_chosen(1:counter-1);
    disp('Check the margin of the A-R constant c.')
end

beta = zeros(N,n,NumWaveHeadings);

for k=1:NumWaveHeadings
    beta(:,:,k) = alpha(:,index_chosen,k);
end

% Bin_phase_for_visualization=linspace(-pi,pi,25);

% [OMEGA3,PHASE3,PDF3]=processRawPhases(omega',bin_phase_for_visualization,beta1,104);

% ------- the difference between two PDFS (before and after the A-R method)
% figure(999)
% surf(OMEGA3,PHASE3,PDF2-PDF3)
% -------------------------------------------------------------------------

disp(' ')
toc

% figure(9)
% hist(x1_processed,NumBinsX);
% [Nx1,x_exact2]=hist(x1_processed,NumBinsX);  hold on;
% x_exact1=linspace(0.9*min(x1_processed),1.1*max(x1_processed),1000);
% plot(x_exact1,f_ev(x_exact1)*n*(x_exact2(2)-x_exact2(1)),'r');grid on
% xlabel('$x/\sigma$','FontSize',20);ylabel('Occurrence','FontSize',20)
% legend('DLG','THEORY')
% title_content=strcat('$\#$ of Wave Components = ',num2str(N*NumWaveHeadings),', $\#$ of Realizations = ',num2str(counter-1));
% title(title_content)
% axis([2 8 0 1.5*(max(Nx1))])

figure(9)
histogram(x1_processed);
[Nx1,x_exact2]=hist(x1_processed,NumBinsX);  hold on;
x_exact1=linspace(0.9*min(x1_processed),1.1*max(x1_processed),1000);
plot(x_exact1,f_ev(x_exact1)*n*(x_exact2(2)-x_exact2(1)),'r');grid on
xlabel('$x/\sigma$','FontSize',20);ylabel('Occurrence','FontSize',20)
legend('DLG','THEORY')
title_content=strcat('$\#$ of Wave Components = ',num2str(N*NumWaveHeadings),', $\#$ of Realizations = ',num2str(counter-1));
title(title_content)
axis([2 8 0 1.5*(max(Nx1))])

figure(999)
[FCDF,XCDF]=ecdf(x1_processed);
plot(XCDF,FCDF,XCDF,F_ev(XCDF))
xlabel('$x/\sigma$','FontSize',20);ylabel('CDFs','FontSize',20)
legend('DLG','THEORY')

%% Visualization and LAMP wave file generation

disp(' ')
N_realization = input('# of LAMP wave files (N_realization) to be generated? ');
N_realization = round(N_realization);

tic

if N_realization > n
    disp(' ')
    disp('Since N_realization you entered is bigger than n, N_realization is set to n. ');
    disp('If you want N_realization LAMP wave files, please run DLG3 again with n=N_realization.')
    disp(' ')
    N_realization = n;
end

outputstats(x1_processed(1:N_realization),ResponseRMS,CaseNumber)

wave_number_k = omega.^2/Gravity;   % wave number k - based on omega, not omega_e
omega_e = zeros(NumWaveHeadings,N);
heading_array = zeros(NumWaveHeadings,N);

for k=1:NumWaveHeadings
    omega_e(k,:)=omega-Velocity*wave_number_k*cos(WaveHeadings(k)/180*pi);
    heading_array(k,:)=WaveHeadings(k)*ones(1,N)*pi/180;   % in radian
end

t=t0:0.02:-t0;

% Show only one example time series - will be duplicated below
%%

if MaximaOrMinima == 2   % if minima is desired
	beta=beta+pi;

    disp(' ')
    disp({'Phase angles have been flipped to get the minima as requested.'})
end

res=zeros(1,length(t));
inc=zeros(1,length(t));

%%

% Make a folder and designate folder location using fullfile.

[~, ~, ~]=mkdir('Outputs/DLG_outputs');
[~, ~, ~]=mkdir('Outputs/LAMP_inputs');
%AWT Feb 16, 2016
[~, ~, ~]=mkdir('Outputs/AWT_outputs');

% For the consistent output file name

if N_realization<100
    num_digits=3;
else
    num_digits=length(num2str(N_realization));
end

resmean=zeros(1,length(t));
selected_phase = zeros(NumWaveHeadings,N);

for k = 1:N_realization
    
 %   beta = zeros(N,n,NumWaveHeadings);

    
    [Char_SeqNo]=generateConsistentCharNumber(k,num_digits);
    
    for kk=1:NumWaveHeadings
        selected_phase(kk,:)=beta(:,k,kk);
    end
    
    res=zeros(1,length(t));
    inc=zeros(1,length(t));
    
    
    for w=1:length(omega)
            
        % TransferPhase is in radian. The sign infront of TransferPhase
        % is dependent on the definition of the transfer function.
        %SIGN CHANGED ON TransferPhas BY AWT, FEB 11, 2016 TO MATCH LMAP
        %SIMULATIONS IN THE DEVELOPMENT OF GENERAL Transfer function
        
        %%% note change made in time series reconstruction of inc where
        %%% instead of +TransferPhase now -TransferPhase. This is done so
        %%% when negative shipmo phases are read into DLG, the correct
        %%% lead/lag betwene wave and response is recovered 
        %%% change made by HCS on 11/2/2016
        
        for kkk=1:NumWaveHeadings
            %%%% commented lines are original DLG, see change above
%             res = res + a(kkk,w)*cos(-omega_e(kkk,w)*t + selected_phase(kkk,w));
%             inc = inc + a_excitation(kkk,w)*cos(-omega_e(kkk,w)*t + selected_phase(kkk,w) + TransferPhase(kkk,w));
            res = res + a(kkk,w)*cos(-omega_e(kkk,w)*t + selected_phase(kkk,w));
            inc = inc + a_excitation(kkk,w)*cos(-omega_e(kkk,w)*t + selected_phase(kkk,w) - TransferPhase(kkk,w));
        end
        
    end
    
    %% display the first example

    if k == 1
        figure(10)
        subplot(211)
        plot(t,inc);hold on;grid on;ylabel('Incident Wave','FontSize',20);
        title('An Example Realization');
        subplot(212)
        plot(t,res);hold on
        xlabel('Time [sec]','FontSize',20)
        ylabel('Response','FontSize',20);grid on;
    end 
    
    % Definition of TransferPhase Used in the calculation of TransferFunction.
    %===========================================
    %+res = H*inc*cos(-omega_e*t+TransferPhase)+
    %===========================================
    % When it is from inc to res, use +TransferPhase.
    % If it is the other way around, use -TransferPhase.
    
    % selected_phase -> Wave phase for irregular wave (epsilon)
    
    TimeHistories=[t ; inc ; res];
    output_file=fullfile('Outputs','DLG_outputs',strcat('TimeHistories_Case',Char_CaseNo,'_',Char_SeqNo,'.txt'));
    fid=fopen(output_file,'wt');
%     fprintf(fid,'       Time             IncidentWave        Response   \n');	
    fprintf(fid,'%12.4f          %12.6f    %16.6E  \n',TimeHistories);
    fclose(fid);
    
    % Output file for K. Maki to reproduce response and incident wave time
    % series.  Written by AWT Feb. 16 2016
    % NOTE, THE ARRAY DIMENSIONS MAY NOT WORK FOR NumWaveHeadings>1
    %S
    
    
   % AWT_output = [omega' ; omega_e ; wave_number_k' ; a ; a_excitation ; selected_phase ; TransferPhase];
    output_file=fullfile('Outputs','AWT_outputs',strcat('AWT_Data_Case',Char_CaseNo,'_',Char_SeqNo,'.txt'));
    fid=fopen(output_file,'wt');
%     fprintf(fid,'    omega            omega_e      wave_number     a_resp_amp       a_excite        select_phase   TransferPhase   WaveHeading\n');	

    for kk=1:NumWaveHeadings
    AWT_output = [omega' ; omega_e(kk,:) ; wave_number_k' ; a(kk,:) ; a_excitation(kk,:) ; selected_phase(kk,:) ; TransferPhase(kk,:); heading_array(kk,:)*180/pi];
     %           1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890
    fprintf(fid,'%12.6f     %12.6f    %12.5E    %12.5E    %12.5E    %12.5f    %12.5f   %12.5f  \n',AWT_output);

    end
    
    fclose(fid);
    %
    %End of Feb 16, 2016 edits
    %
    
% % %     output_file=fullfile('Outputs','LAMP_inputs',strcat('Case',Char_CaseNo,'_',Char_SeqNo,'.waves'));
% % %     fid=fopen(output_file,'wt');
% % %     fprintf(fid,strcat('!LAMP INPUT FILE (CaseNumber = ',Char_CaseNo,', TNIT = ',num2str(t0),', NWAVES = ',num2str(N*NumWaveHeadings),') \n'));
% % %    
% % %         %SIGN CHANGED ON TransferPhas BY AWT, FEB 11, 2016 TO MATCH LMAP
% % %         %SIMULATIONS IN THE DEVELOPMENT OF GENERAL Transfer function
% % %         
% % %     for kk=1:NumWaveHeadings
% % %         Compensated_LAMP_Phase= selected_phase(kk,:) + TransferPhase(kk,:) + wave_number_k'*Velocity*t0.*cos(heading_array(kk,:)); 
% % %         LAMPwave=[omega'; Compensated_LAMP_Phase*180/pi;  a_excitation(kk,:);  heading_array(kk,:)*180/pi];
% % %         fprintf(fid,'%12.8f       %16.6E    %16.6E      %12.2f  \n',LAMPwave);
% % %     end
% % %     
% % %     fclose(fid);
% % %     %
% % %     %
% % %     %Generate additional LAMP_OPENFOAM file per K. Maki's Nov. 13, 2015
% % %     %email
% % %     %
% % %     %
% % %     output_file2=fullfile('Outputs','LAMP_MAKI_inputs',strcat('Case',Char_CaseNo,'_',Char_SeqNo,'.waves'));
% % %     fid2=fopen(output_file2,'wt');
% % %     fprintf(fid2,strcat('!LAMP INPUT FILE (CaseNumber = ',Char_CaseNo,', TNIT = ',num2str(t0),', NWAVES = ',num2str(N*NumWaveHeadings),') \n'));
% % %     
% % %     
% % %         %SIGN CHANGED ON TransferPhas BY AWT, FEB 11, 2016 TO MATCH LAM8=8P
% % %         %SIMULATIONS IN THE DEVELOPMENT OF GENERAL Transfer function
% % %         
% % %     for kk=1:NumWaveHeadings
% % %         Compensated_LAMP_Phase2_temp= selected_phase(kk,:) + TransferPhase(kk,:) + wave_number_k'*Velocity*t0.*cos(heading_array(kk,:)+omega'*t0); 
% % %         %
% % %         %Convert Phases to +/- pi to avoid excessively large phases
% % %         %
% % %         Compensated_LAMP_Phase2=wrapToPi(Compensated_LAMP_Phase2_temp);
% % %         LAMPwave2=[omega'; Compensated_LAMP_Phase2*180/pi;  a_excitation(kk,:);  heading_array(kk,:)*180/pi];
% % %         fprintf(fid2,'%12.8f       %16.6E    %16.6E      %12.2f  \n',LAMPwave2);
% % %     end
% % %     
% % %     fclose(fid2);
end

disp(' ')
disp('DLGpost has been completed.')
disp(' ')

toc