function DLGmain

clear all;close all;clc

tic

set(0,'DefaultAxesFontSize',20)
set(0,'defaulttextinterpreter','latex')

global NumWaveHeadings a s_opt FT_opt

rand('twister',sum(1e5*clock))

temp_filename=fullfile('Inputs','CaseParameters.dat'); 
[data, ~] = textread(temp_filename,'%f %s','headerlines',0);

NumCompIn = data(1);
N = data(2);
io = data(3);
fo = data(4);
TEV = data(6);
CaseNumber = data(7);
Heading = data(8);
Gravity = data(10);

% -------------------------------------------------------------------------
% Note: If Heading is 1000, the program reads in the data from WaveHeadings.dat
% -------------------------------------------------------------------------

TEV_init = 3; 
TEV_shift=TEV-TEV_init;

MaxRuns = 10000;

m=round(TEVtoNumberOfSamples(TEV));
m0=round(TEVtoNumberOfSamples(TEV_init));

% size(a) = (NumWaveHeadings, N);

if Heading == 1000
    temp_filename=fullfile('Inputs','WaveHeadings.dat');
    WaveHeadings=load(temp_filename);
    NumWaveHeadings=length(WaveHeadings);
else
    NumWaveHeadings=1;
end

a=zeros(NumWaveHeadings,N);
ResponseVar = 0;

if NumWaveHeadings == 1
       a(1,:)=load(fullfile('Inputs',strcat('a.dat')));
       ResponseVar = ResponseVar + 1/2*sum(a(1,:).^2);    
else
    for k=1:NumWaveHeadings
       a(k,:)=load(fullfile('Inputs',strcat('a',num2str(k),'.dat')));
       ResponseVar = ResponseVar + 1/2*sum(a(k,:).^2);
    end
    %another way of doing this job is k=[] inside for loop. 
end

ResponseRMS=sqrt(ResponseVar);

omega = load(fullfile('Inputs','omega.dat'));  % same for all headings


% If I want to combine it....a=zeros(Nh,N)... a1=a(1,:)...
% similarily omega=zeros(Nh,N).....omega1=omega(1,:)...


% This should be same with N(a2) for now. You may want to insert a routine
% to check it. Technically speaking, it doesn't have to so.

% N=length(a1);  

% Random number and signal generation -------------------------------------
LargestX=zeros(1,MaxRuns);
TEValpha=zeros(N,MaxRuns,NumWaveHeadings);

tic 

for iRun=1:MaxRuns
    
    % You may want to do the following as a nested for-loop.
    
    x=zeros(1,m0);
    alpha = 2*pi*(rand(N,m0,NumWaveHeadings) - 0.5);

    for iWaveHeading=1:NumWaveHeadings
        x=x+a(iWaveHeading,:)*cos(alpha(:,:,iWaveHeading));
    end
    
    % size(x)= (1,N)*(N*m) = (1,m)
    
    %x=x/ResponseRMS;                   % normalization
    [LargestX(iRun), l]=max(x);         % find maximum
    
    % Find the set of phase angles associated with the maximum in m
%     
    for iWaveHeading=1:NumWaveHeadings
        TEValpha(:,iRun,iWaveHeading)=alpha(:,l,iWaveHeading);
    end
    
    % Find the phase associate with max in m; size(TEValpha) = (N , MaxRuns) 
    
end

%% Visualizaton of Phase Histogram and EV PDF

% The size of TEValpha_column should be (N*Maxruns, 1)
 
% for iWaveHeading=1:NumWaveHeadings
%     TEValpha_column(:,iWaveHeading)=reshape(TEValpha(:,:,iWaveHeading),N*iRun,1);
% end

% figure(3)
% [N_in_bin, bin_center]=hist(LargestX/ResponseRMS,30);
% 
% hist(LargestX/ResponseRMS,30);hold on
% f_ev=@(x) m*1/(sqrt(2*pi))*exp(-1/2*x.^2).*normcdf(x).^(m-1);x_exact=linspace(0,7,1000);
% plot(x_exact,f_ev(x_exact)*MaxRuns*(bin_center(2)-bin_center(1)))

%% Least Square for Estimating lambda_j and lamba_k for each omega_

bin_phase_for_visualization=linspace(-pi,pi,25);

processRawPhases(omega',bin_phase_for_visualization,TEValpha(:,:,1),1);
%processRawPhases(omega',bin_phase_for_visualization,TEValpha(:,:,2),2);
% processRawPhases(omega',bin_phase_for_visualization,TEValpha3,3);
% processRawPhases(omega',bin_phase_for_visualization,TEValpha4,4);
% processRawPhases(omega',bin_phase_for_visualization,TEValpha5,5);

lambda=zeros(NumWaveHeadings,N);
options=optimset('Display','off');

for k=1:N

%    % size(TEValpha) = N*MaxRuns*NumWaveHeadings     
    for kk=1:NumWaveHeadings
        [CDFtemp,xforCDF]=ecdf(TEValpha(k,:,kk));
        lambda(kk,k)=fminbnd(@modGaussCDFfit,0,10,options,xforCDF,CDFtemp);
    end
    
end

% Write Out to External Output Files

[Char_CaseNo]=generateConsistentCharNumber(CaseNumber,3);

if NumWaveHeadings == 1
        fout=[omega'; lambda(1,:)];
        fid = fopen(fullfile('Outputs',strcat('LambdasCase',Char_CaseNo,'.dat')),'wt');
        fprintf(fid,'%16.15E    %16.15E   \n',fout);
        fclose(fid);
else
    for kk=1:NumWaveHeadings
        fout=[omega'; lambda(kk,:)];
        fid = fopen(fullfile('Outputs',strcat('LambdasCase',Char_CaseNo,'a',num2str(kk),'.dat')),'wt');
        fprintf(fid,'%16.15E    %16.15E   \n',fout);
        fclose(fid);
    end
end


%% Characteristic Functions

%figure(9)
Smax_orig = determineSmax(ResponseRMS,TEV);  % Original TEV
 
s_orig=linspace(0,Smax_orig,256);    % Seems working but need to check if this is the optimal value.

fun_rhs_temp=ones(NumWaveHeadings,length(s_orig));

%lambda=zeros(NumWaveHeadings,N);
%options=optimset('Display','off');
% size(a) = (NumWaveHeadings, N);

for k=1:NumWaveHeadings
    for kk=1:length(s_orig)   
        fun_rhs_temp(k,kk) = rhs_component_vec_adaptive(lambda(k,:),a(k,:),s_orig(kk)); 
    end
end

fun_rhs_temp_tot=prod(fun_rhs_temp,1);
    
fun_rhs=exp(1i*s_orig*TEV_shift*ResponseRMS).*fun_rhs_temp_tot;  % e.g., trasform to higher TEV... to be optimized

% subplot(211);hold on
% plot(s_orig,real(fun_rhs),'k')
% subplot(212);hold on
% plot(s_orig,imag(fun_rhs),'k')
% % 
% 
%%

% The right hand side of the governing equation.
FT1 = zeros(1,2^(nextpow2(length(s_orig))*2));  % no basis on the dimension; but seems suitable at this point. To be reviewed rigorously.
FT1(1:length(fun_rhs))=fun_rhs;

% FT0: Symmetric Part of FT1
FT0 = zeros(1,2^(nextpow2(length(s_orig))*2));
starting_point=length(FT0)-length(fun_rhs(end:-1:2))+1;
FT0(starting_point:end)=conj(fun_rhs(end:-1:2));

% Combine Both Sides
FT=[FT0 FT1];
NFFT = length(FT);

% new Fmax due to the zero padding 
ds=s_orig(2)-s_orig(1); df=ds/(2*pi);
Fmax = df*(NFFT/2); % not sure -1 is needrf or not (Fmax = df*(NFFT/2 -1) was used originally. Seems that the one without -1 is correct.
Smax = 2*pi*Fmax; % nnot a good notation

% the vector 's' that goes with 'FT'
new_s=linspace(-Smax,Smax-ds,length(FT));

% figure(9);  % on top of the characteristic funtion of theoretical evPDF
% subplot(211);hold on
% plot(new_s,real(FT),'r');
% legend('Theory','DLG')
% subplot(212);hold on
% plot(new_s,imag(FT),'r')
% legend('Theory','DLG')
%  
%% How to find new_lambda easily

c_index=find(abs(FT) >= 0.01*max(abs(FT)));

% figure(9);
% subplot(211);hold on
% scatter(new_s(c_index),real(FT(c_index)),'.')
% subplot(212);hold on
% scatter(new_s(c_index),imag(FT(c_index)),'.')

% Apply Optimization ------------------------------------------------
%
% length(s_opt) is around 30 - 45 depending on TEV. If the accuracy is a 
% problem, the code above may be modfied. Since we are not trying to make 
% a perfet match any longer, however, it is expected to be ok. 

startP_opt = round(length(c_index)/2);  

% A Set of Lambdas That Generates This Figure to be found from Optimization

s_opt = new_s(c_index(startP_opt:end));
FT_opt = FT(c_index(startP_opt:end));

% figure(99);
% subplot(211);
% plot(s_opt,real(FT_opt),'.');grid
% title_content=strcat(' # of Points = ',num2str(length(s_opt)));
% title(title_content)
% subplot(212);
% plot(s_opt,imag(FT_opt),'.');grid


%% Optimization of the cost function
 
disp({'The optimization of the cost function has started.'})
disp(' ')

NRepetition = 5; Ndiscretization = 8;
symbols=['^','v','s','o','*'];
 
tested_lambda_o=zeros(NRepetition,Ndiscretization);  
calculated_cost=zeros(NRepetition,Ndiscretization);    

lambda_o_bL=0.05*min(min(lambda));  
lambda_o_bR=0.75*min(min(lambda));

for kk=1:NRepetition   
    [cost,opt_lambda_o,new_lambda_o_bL,new_lambda_o_bR] ...
        =cost_optimization(lambda,lambda_o_bL,lambda_o_bR,Ndiscretization);
   
    tested_lambda_o(kk,:) = linspace(lambda_o_bL,lambda_o_bR,Ndiscretization);
    calculated_cost(kk,:) = cost;
    
    figure(100)
    scatter(tested_lambda_o(kk,:),calculated_cost(kk,:),symbols(kk));hold on

    lambda_o_bL=new_lambda_o_bL;
    lambda_o_bR=new_lambda_o_bR;
end

% Take the opt_lambda_o from the last step (NReptition = 5) as the
% optimized lambda_o.

new_lambda = lambda - opt_lambda_o;
 
figure(100);
xlabel('$\lambda_o$','FontSize',12);ylabel('g_{objective}','FontSize',12);
axis([0 1.2*max(tested_lambda_o(1,:)) 0 1.2*max(calculated_cost(1,:))]);
box on;grid on;
legend('1st Round','2nd Round','3rd Round','4th Round','5th Round');
title('The Objective Function')

if NumWaveHeadings == 1
        fout=[omega'; new_lambda(1,:)];
        fid = fopen(fullfile('Outputs',strcat('NewLambdasCase',Char_CaseNo,'.dat')),'wt');
        fprintf(fid,'%16.15E    %16.15E   \n',fout);
        fclose(fid);
else

    for kk=1:NumWaveHeadings
        fout=[omega'; new_lambda(kk,:)];
        fid = fopen(fullfile('Outputs',strcat('NewLambdasCase',Char_CaseNo,'a',num2str(kk),'.dat')),'wt');
        fprintf(fid,'%16.15E    %16.15E   \n',fout);
        fclose(fid);
    end

end


%% Reconstruction of Target Characteristic Function using new_lambdas 

% Any chance we can vectorize rhs_component to speed up. 
% Or to chage the domain of s adaptively according to TEV is possible?

fun_rhs_after = ones(NumWaveHeadings,length(s_orig));

for k=1:NumWaveHeadings
    for kk=1:length(s_orig)   
        fun_rhs_after(k,kk) = rhs_component_vec_adaptive(new_lambda(k,:),a(k,:),s_orig(kk)); 
    end
end

fun_rhs=prod(fun_rhs_after,1);
%fun_rhs=fun_rhs1.*fun_rhs2.*fun_rhs3.*fun_rhs4.*fun_rhs5;

FT1 = zeros(1,2^(nextpow2(length(s_orig))*2));  % no basis; but seems suitable at this point. To be reviewed rigorously.
len_sig=length(fun_rhs);

% The right hand side of the governing equation.
FT1(1:len_sig)=fun_rhs;

% FT0: Symmetric Part of FT1
FT0 = zeros(1,2^(nextpow2(length(s_orig))*2));
starting_point=length(FT0)-length(fun_rhs(end:-1:2))+1;
FT0(starting_point:end)=conj(fun_rhs(end:-1:2));

FT=[FT0 FT1];
NFFT = length(FT);

% new Fmax due to the zero padding 
ds=s_orig(2)-s_orig(1); df=ds/(2*pi);
Fmax = df*(NFFT/2); % not sure -1 is needrf or not (Fmax = df*(NFFT/2 -1) was used originally. Seems that the one without -1 is correct.
Smax = 2*pi*Fmax; % nnot a good notation

% the vector 's' that goes with 'FT'
new_s=linspace(-Smax,Smax-ds,length(FT));

% figure(99);
% subplot(211);hold on
% plot(new_s,real(FT),'r');
% axis([0 2*s_opt(end) -1 1])
% subplot(212);hold on
% plot(new_s,imag(FT),'r')
% axis([0 2*s_opt(end) -1 1])

%%

dx=1/(2*Fmax);
fs=1/(NFFT*dx);

% Approximated extreme value PDF from IFFT based on new_lambda

signal_reconst=ifft(conj(ifftshift(FT))/dx,NFFT);
x_reconst=[0:dx:(NFFT-1)*dx];

% normalization of the approximated extreme value pdf
norm_signal_reconst=signal_reconst*ResponseRMS;
norm_x_reconst=x_reconst/ResponseRMS;

% TEV 9 is a practical limit
x_limit_ind=find(norm_x_reconst>9,1);

% extreme value pdf from our model (normalized) - throw out exessive data generated by IFT 
norm_signal_reconst=norm_signal_reconst(1:x_limit_ind);
norm_x_reconst=norm_x_reconst((1:x_limit_ind));

% The original target signal 
m_target=round(1/(1-normcdf(TEV))); 
f_ev=@(x) m_target*1/(sqrt(2*pi))*exp(-1/2*x.^2).*normcdf(x).^(m_target-1);

% Find a bound meaningfull range: 1 in 100 thousand samples

p_min = 0.00001;

indx_bound=find(f_ev(norm_x_reconst)>p_min);  % this is a key information  
lower_indx=indx_bound(1);
higher_indx=indx_bound(end);

[Max_ratio,l_Max_ratio]=max(f_ev(norm_x_reconst(lower_indx:higher_indx))./norm_signal_reconst(lower_indx:higher_indx));
x_ref=norm_x_reconst(lower_indx+l_Max_ratio-1);  % is this necessary?

c=1.03*f_ev(norm_x_reconst(lower_indx+l_Max_ratio-1))/norm_signal_reconst(lower_indx+l_Max_ratio-1); % 10% margin seems to be enough.

% comparison of f(X) and g(X)
figure(101);hold on
plot(norm_x_reconst,f_ev(norm_x_reconst),norm_x_reconst,norm_signal_reconst,norm_x_reconst,c*norm_signal_reconst)
axis([0 10 0 1.2*max(c*norm_signal_reconst)]);box on;grid on;

legend('Exact EV PDF','Approx. EV PDF','c * Approx. EV PDF','Location','NorthWest')
title(strcat('c = ',num2str(c)))

x_center=norm_x_reconst;
x_PDF=norm_signal_reconst;
fout=[x_center; x_PDF];  

filename=strcat('evPDFrawCase',Char_CaseNo,'.dat');
evPDF_filename=fullfile('Outputs',filename); 
fid=fopen(evPDF_filename,'wt');
fprintf(fid,'     x/ResponseRMS                         Approx_EV_PDF  \n');	
fprintf(fid,'%16.15E                 %16.15E  \n',fout);
fclose(fid);

filename=strcat('TheConstantCforARmethod',Char_CaseNo,'.dat');
TheConstantC_filename=fullfile('Outputs',filename); 
fid4=fopen(TheConstantC_filename,'wt');
fprintf(fid4,strcat('c \t ',num2str(c),'\n'));
fprintf(fid4,strcat('x_min \t ',num2str(norm_x_reconst(lower_indx)),'\n'));
fprintf(fid4,strcat('x_max \t ',num2str(norm_x_reconst(higher_indx)),'\n'));
fprintf(fid4,strcat('p_lowest \t ',num2str(p_min),'\n')); 
fclose(fid4); 

disp(' ')
disp('DLGmain has been completed.')
disp(' ')

toc
