function cdfInfo = getCDFinfo(MphiK1,MphiK2,MphiK3,MphiK4,MphiK5,MphiK6,rmsDLG)
%%% function to read in time series constructed by the DLG from surrograte
%%% processes 1, 2, and 3. Code checks is any of z1hat, z2hat, and/or z3hat
%%% exist in the time series, and whether failure occurs for CS1-6.

tic

nsim = 1000;

%%% everything normalized by TEV

%%% make a struct to hold cdf values of zk_i^hat conditioned on extreme
%%% zk_j^hat vales
seq = 1000:-1:1;
seq = seq';
pne = 1-seq./1000;

field1 = 'k1';      value1 = zeros(nsim,7);
field2 = 'k2';      value2 = zeros(nsim,7);
field3 = 'k3';      value3 = zeros(nsim,7);
field4 = 'k4';      value4 = zeros(nsim,7);
field5 = 'k5';      value5 = zeros(nsim,7);
field6 = 'k6';      value6 = zeros(nsim,7);
field7 = 'pne';     value7 = pne;


cdfInfo = struct(field1,value1,field2,value2,field3,value3,field4,value4,...
    field5,value5,field6,value6,field7,value7);

fields = fieldnames(cdfInfo);

folders = {'SeaState/30min/z1P','SeaState/30min/z2P','SeaState/30min/z3P',...
    'SeaState/30min/z4P','SeaState/30min/z5P','SeaState/30min/z6P'};

% folders = {'SeaState/30min/z1','SeaState/30min/z2','SeaState/30min/z3',...
%     'SeaState/30min/z4','SeaState/30min/z5','SeaState/30min/z6'};

% folders = {'SeaState/25hr/z1','SeaState/25hr/z2','SeaState/25hr/z3',...
%     'SeaState/25hr/z4','SeaState/25hr/z5','SeaState/25hr/z6'};

normzk = zeros(nsim,7);

for f = 1:6
    folder = folders{f};
    for h = 1:nsim
        %%% function to read in DLG time series
        [~,zk1,zk2,zk3,zk4,zk5,zk6] = DLGTS(h,MphiK1,MphiK2,MphiK3,MphiK4,MphiK5,MphiK6,folder);
            
        normzk(h,1) = zk1/rmsDLG(1);        
        normzk(h,2) = zk2/rmsDLG(2);
        normzk(h,3) = zk3/rmsDLG(3);        
        normzk(h,4) = zk4/rmsDLG(4);
        normzk(h,5) = zk5/rmsDLG(5);        
        normzk(h,6) = zk6/rmsDLG(6);        
        normzk(h,7) = h;
    end
    
    %%% sort based on extreme zk Value
    [~,I] = sort(normzk(:,f));
    cdfInfo.(fields{f}) = normzk(I,:);
    
end

toc
    
    function [Z,zk1,zk2,zk3,zk4,zk5,zk6] = DLGTS(k,MphiK1,MphiK2,MphiK3,MphiK4,MphiK5,MphiK6,folder)

        [Char_SeqNo]=generateConsistentCharNumber(k,4);
        temp_filename=fullfile(folder,'Outputs','AWT_outputs',strcat('AWT_Data_Case001_',Char_SeqNo,'.txt'));
        AWTout = load(temp_filename);

        t = 0;
        %%% need to choose length of time
        t = t';
        Z = zeros(size(t));
        zk1 = zeros(size(t));
        zk2 = zeros(size(t));
        zk3 = zeros(size(t));
        zk4 = zeros(size(t));
        zk5 = zeros(size(t));
        zk6 = zeros(size(t));

        
        % Definition of TransferPhase Used in the calculation of TransferFunction.
        %===========================================
        %+res = H*inc*cos(-omega_e*t+TransferPhase)+
        %===========================================
        % When it is from inc to res, use +TransferPhase.
        % If it is the other way around, use -TransferPhase.

        %%% to reconstruct other responses (not what DLG maximized phases for) use:
        %%% selectPhase (AWT(:,6)) - transferPhase (AWT(:,7)) + ShipmoPhase (Mphi)

        %%% to reconstruct eta when the TransferFunction is for a response, use:
        %%% selectPhase (AWT(:,6)) - transferPhase (AWT(:,7)) = wave (select) phase

        for j = 1:length(MphiK1)
            Z = Z + AWTout(j,5).*cos(-AWTout(j,2)*t + AWTout(j,6) - AWTout(j,7));
            zk1 = zk1 + AWTout(j,5).*MphiK1(j,1).*cos(-AWTout(j,2)*t + AWTout(j,6) - AWTout(j,7) + (MphiK1(j,2)));
            zk2 = zk2 + AWTout(j,5).*MphiK2(j,1).*cos(-AWTout(j,2)*t + AWTout(j,6) - AWTout(j,7) + (MphiK2(j,2)));
            zk3 = zk3 + AWTout(j,5).*MphiK3(j,1).*cos(-AWTout(j,2)*t + AWTout(j,6) - AWTout(j,7) + (MphiK3(j,2)));
            zk4 = zk4 + AWTout(j,5).*MphiK4(j,1).*cos(-AWTout(j,2)*t + AWTout(j,6) - AWTout(j,7) + (MphiK4(j,2)));
            zk5 = zk5 + AWTout(j,5).*MphiK5(j,1).*cos(-AWTout(j,2)*t + AWTout(j,6) - AWTout(j,7) + (MphiK5(j,2)));
            zk6 = zk6 + AWTout(j,5).*MphiK6(j,1).*cos(-AWTout(j,2)*t + AWTout(j,6) - AWTout(j,7) + (MphiK6(j,2)));
        end 
    end 
end
