function Pstats = failureProbALL(DLGstats,nSP,ziHOLD,loc)
nsim = 1000; %number of DLG TS
allSP = 1:nSP;

%%% get number of maxima congfigurations gievn number of SP, n
[Bn, ~] = Bell(nSP);

%%% make struct to hold p(config) and p(safety|config) for 6 panels
field1 = 'pConfig'; value1 = ones(Bn,1); %%% prob of maxima config

Pstats = struct(field1,value1);
fields = fieldnames(Pstats);

%%% get probability of each ordering given n SP (n!)
pOrder = 1/factorial(nSP);

%%% matrix to hold p(config.)- col1, and p(safety|config.)- col2, col3,...
%%% each column holds p(zi), p(zij), ect.
probHold = ones(Bn,1);

counter = 1;
%%% now go through 1-n groups for maxima configurations
for k = 1:nSP
    list = SetPartition(nSP,k);
    num = length(list); %number of configurations given the # of groups

    %%% go through all configurations given group number k
    for h = 1:num
        innerCount = 1;
        configZiHat = ones(1,nSP);

        %%% index through k parts of group
        for g = 1:k
            members = list{h,1}{1,g};
            numMembers = length(members);

            %%% add these probabilities together
            membersProb = 0;

            %%% to concatenate all ziHAT of same "type" e.g. z123,
            %%% z213, z312 are all the "same"
            ziHOLDconcat = 1;

            for i = 1:numMembers %%% k members of maxima config.
                range = (loc(members(i),1):loc(members(i),2))'; 
                part = members(ismember(members,allSP));
                notPart = allSP(not(ismember(allSP,members)));
                partMat = ziHOLD(range,part);

                %%% which time series have all ziHAT in group
                mult = ones(nsim,1);
                    for y = 1:numMembers
                        mult = mult .* partMat(:,y);
                    end

                %%% minus any ziHAT not part of group
                if isempty(notPart) == 0
                    notPartMat = ziHOLD(range,notPart);

                    for z = 1:length(notPart)
                        mult = mult - notPartMat(:,z);
                    end    
                end

                %%% find time series which satisfy ziHAT condition-
                %%% 1 or 0
                haveZiHat1 = mult;
                haveZiHat1(haveZiHat1<0)=0;

                membersProb = membersProb + sum(haveZiHat1)/nsim;
                configZiHat(g) = membersProb;

                %%% find p(safety|config & design) for ziHAT 

                %%% find time series which satisfy ziHAT condition-
                %%% keep time series marker to compare with ff
                haveZiHat = mult .* DLGstats.ziHAT(range,1);
                haveZiHat(haveZiHat<0)=0;
                haveZiHat(all(haveZiHat==0,2),:)=[];

                %%% concatenate all ziHAT of same "type" 
                ziHOLDconcat = [ziHOLDconcat; haveZiHat];
                innerCount = innerCount + 1;
            end

            %%% get rid of original placeholder 1
            ziHOLDconcat = ziHOLDconcat(2:end);

            %%% if no time series fulfill ziHAT criterion, make the
            %%% vector "1"; since all ff>=1000, this will be not be
            %%% associated with any failures
            if isempty(ziHOLDconcat)
                ziHOLDconcat = 1;
            end 
        end
        
        %%% multiply (potentially summed) probabilites 1-k 
        pC = 1;

        for y = 1:nSP
            pC = pC*configZiHat(y);
        end            

        %%% multiply together probabilities based on group structure
        %%% probabilities not yet conditioned on successful configuration
        probHold(counter,1) = pOrder * pC * factorial(k) * factorial(nSP-k);

        counter = counter + 1;
    end
end

pSuccess = sum(probHold(:,1));
probHold(:,1) = probHold(:,1) / pSuccess;

%%% probability of maxima configurations
Pstats.(fields{1}) = probHold; 

end