function zkHatData = calcZkHat(PtReyesBuoyData,rmsPtReyes)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Find wave groups from time series %%% 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

set(0,'DefaultAxesFontSize',20)
set(0,'defaulttextinterpreter','latex')
set(groot, 'defaultAxesTickLabelInterpreter','latex');
set(groot, 'defaultLegendInterpreter','latex');

close all

%%% remove any repeated rows in struct
[~,ia] = unique(PtReyesBuoyData.z, 'rows');
max(ia)
PtReyesBuoyData.time = PtReyesBuoyData.time(ia,:);
PtReyesBuoyData.z = PtReyesBuoyData.z(ia,:);
PtReyesBuoyData.znorm = PtReyesBuoyData.znorm(ia,:);
PtReyesBuoyData.Hs = PtReyesBuoyData.Hs(ia,:);
PtReyesBuoyData.Tp = PtReyesBuoyData.Tp(ia,:);

dt = 1800/2304; %1800 seconds, 2304 points

zkHatData = process(PtReyesBuoyData,rmsPtReyes,dt);

fields1 = fieldnames(zkHatData);

for i = 1:12
    zkHatData.(fields1{i}) = zkHatData.(fields1{i})(any(zkHatData.(fields1{i}),2),:);
end


% %%% Uncomment if to plot spectrum
% dw = 2*pi/(2304*dt);
% omega = dw:dw:2*pi/dt;
% spectra = zeros(1,2304);
% 
% for j = 1:size(zkHatData.z1,1)
%     spectra(j,:) = 2*(abs(fft(zkHatData.z1(j,:))/2304)).^2/(2*dw);
% end
% 
% AVGspectrum = mean(spectra,1);
% 
% smoothed = zeros(size(AVGspectrum));
% smoothed(1) = AVGspectrum(1);
% smoothed(end) = AVGspectrum(end);
% 
% for j = 2:length(AVGspectrum)-1
%     smoothed(j) = (AVGspectrum(j-1) + AVGspectrum(j) + AVGspectrum(j+1))/3;  
% end
% 
% figure
% plot(omega,spectra(1,:))
% hold on
% plot(omega,AVGspectrum)
% plot(omega,smoothed, 'r', 'LineWidth',3)
% xlabel('Frequency (rad/s)')
% ylabel('Spectral Energy [$m^2$/(rad/s)]')
% title('Average Spectrum')
% legend('REpresentative Spectrum','Average Spectrum' , 'Smoothed Spectrum')
% axis([0 3 0 3])
% 
% figure
% Rcomplex = ifft(smoothed);
% Rraw = ifftshift(real(Rcomplex));
% Rdim = sum(smoothed)*dw/(max(Rraw))*Rraw;
% time = linspace(0,1800,2304);
% plot(time,Rdim)

    function K = process(data,rmsPtReyes,dt)
        set(0, 'DefaultAxesFontSize', 14, 'DefaultTextFontSize', 14);
        top1 = length(data.time);
        
        % [zkHat, date, index, Hs, Tp]
        field1 = 'k1';      value1 = zeros(top1,5);
        field2 = 'k2';      value2 = zeros(top1,5);
        field3 = 'k3';      value3 = zeros(top1,5);
        field4 = 'k4';      value4 = zeros(top1,5);
        field5 = 'k5';      value5 = zeros(top1,5);
        field6 = 'k6';      value6 = zeros(top1,5);

        field7 = 'z1';      value7 = zeros(top1,2304);
        field8 = 'z2';      value8 = zeros(top1,2304);
        field9 = 'z3';      value9 = zeros(top1,2304);
        field10 = 'z4';     value10 = zeros(top1,2304);
        field11 = 'z5';     value11 = zeros(top1,2304);
        field12 = 'z6';     value12 = zeros(top1,2304);

     
        K = struct(field1,value1,field2,value2,field3,value3,field4,value4,...
            field5,value5,field6,value6,field7,value7,field8,value8,...
            field9,value9,field10,value10,field11,value11,field12,value12);

        fields = fieldnames(K);
        
        for m = 1:top1
            Zk = zeros(9,size(data.z,2));
            Tp = data.Tp(m);
            Hs = data.Hs(m);
            tau = 8.55; %separation time between wave peaks in seconds
            r  = round(tau/2/dt);
            
            zeta = data.z(m,:)/100; %put in m
            Zk(1,:) = zeta;       

            [C,index] = max(zeta);  
            
            %%% failure criteria for rejecting a time series 

            A = diff(zeta);
            a = max(A);

            if index == 1
                %skip this time series
                disp('index of wave group occurs too early in record ')
                
            elseif (C - zeta(index - 1))/Hs > 0.8 
                %skip this time series
                disp('spike in elevation')
                
            elseif  a/Hs > 1
                %skip this time series
                disp(strcat('spike in velocity',num2str(m)))

            elseif length(find(isnan(zeta))) >= 1
                %skip this time series
                disp(strcat('NaN entry',num2str(m)))    

            else %this is a good time series...read it in
                Zkmax_hold = C;
                INDEXZkmax_hold = index;
                zeta(isnan(zeta)) = 0; %sometimes buoy crapped out...

                K.(fields{1})(m,1) = Zkmax_hold/rmsPtReyes(1);
                K.(fields{1})(m,2) = data.time(m,1);  
                K.(fields{1})(m,3) = INDEXZkmax_hold;
                K.(fields{1})(m,4) = Hs;
                K.(fields{1})(m,5) = Tp;
                
                K.(fields{10})(m,:) = zeta;
                
                for k = 2:6
                    Zk(k,:) = Zk(k-1,:) + [zeta(1,((k-1)*2*r+1):end) zeros(1,(k-1)*2*r)];
                    [C,index] = max(Zk(k,:));

                    Zkmax_hold = C;
                    INDEXZkmax_hold = index;
                    
                    K.(fields{k})(m,1) = Zkmax_hold/rmsPtReyes(k);
                    K.(fields{k})(m,2) = data.time(m,1); 
                    K.(fields{k})(m,3) = INDEXZkmax_hold;
                    K.(fields{k})(m,4) = Hs;
                    K.(fields{k})(m,5) = Tp;
                    K.(fields{k+6})(m,:) = Zk(k,:);
                end 
            end
        end
    end
end

