function assembleNLDLGjointPDF(option,ka,kb,DLGptrTEV30min,DLGtheoryTEV25hr,zkHatData,MCS25hr,DLGtheoryTEV30min,MCS30min)
%%%%%%% plot histogram of joint wave group occurrences (only 2 surrogate processes considered) %%%%%%%

if option == 1 %buoy, 30-min records
    indP = 3; %column index of max wave group location in DLGstats
    axisL = 5; 
    DLGstats = DLGptrTEV30min;
    PtRstats = zkHatData;
    RCWTsimL = 70/3600; % 70sec, converted to hours
    PtRtime = 0.5; % 30-minute record
    dt = 1800/2304;
end

if option == 2 %MCS 30-min, DLG with theory TEV
    indP = 2; %column index of max wave group location in zkHatData
    axisL = 5;
    DLGstats = DLGtheoryTEV30min;
    PtRstats = MCS30min;
    RCWTsimL = 70/3600; % 70sec, converted to hours
    PtRtime = 0.5; % 30-min record
    hours = 0.5;
    N = 2^20;
    dt = hours*3600 / N;
end

if option == 3 %MCS 25 hr
    indP = 2;
    axisL = 6;
    DLGstats = DLGtheoryTEV25hr;
    PtRstats = MCS25hr;
    RCWTsimL = 70/3600; % 70sec, converted to hours
    PtRtime = 25; % 25-hour record
    hours = 25;
    N = 2^21;
    dt = hours*3600 / N;
end

%%% set ctop so that both have same colorbar range
% ctop = 0.16;
set(0, 'DefaultAxesFontSize', 20, 'DefaultTextFontSize', 20);

%% plot NL-DLG joint PDF
Pstats = failureProbINSIDE(DLGstats,ka,kb);

[ffInfo,masterListDLG,numT,~] = getNLDLGts(Pstats,DLGstats,ka,kb);


% sum up total time associated with NL-DLG process time series
%%% go through maxima config & add up numTS in each config times time of
%%% RCWT sim
fieldsF = fieldnames(ffInfo);

RCWTtimeHR = 0;

for j = 1:length(fieldsF)
    fieldINSIDE = fieldnames(ffInfo.(fieldsF{j}));
    TF = startsWith(fieldINSIDE,'chosen');
    
    for h = 1:length(TF)
        numIN = length( ffInfo.(fieldsF{j}).(fieldINSIDE{h}) ); %get num of TS in cluster
        simIN = numIN * RCWTsimL;
        RCWTtimeHR = RCWTtimeHR + simIN;
    end
end

simTimeDLGhr = RCWTtimeHR;

%%% take TS on masterList, find associated row in DLGstats.ziHAT and plot
%%% pair of ziHAT values as histogram
values = [0 0];

%%% uncomment below if you want wave indices
% valuesOUTd = [0 0 0];

for j = 1:length(masterListDLG)
    a = DLGstats.ziHAT(:,1) - masterListDLG(j);
    
    % find DLGTS corresponding to masterList entry
    b = ~a;
    values = [values; DLGstats.ziHAT(b,ka+1) DLGstats.ziHAT(b,kb+1)];
    
    %%% uncomment below if you want wave indices
%     valuesOUTd = [valuesOUTd; DLGstats.ziHAT(b,1) DLGstats.ziHAT(b,ka+1) DLGstats.ziHAT(b,kb+1)];
end

values = values(2:end,:);
% valuesOUTd = valuesOUTd(2:end,:);

subplot(1,3,1)
[N,~] = hist3(values,'Edges',{0:0.25:axisL 0:0.25:axisL}); 
N = N./sum(N(:));

N_pcolor = N';

x = values(:,1);
y = values(:,2);

N_pcolor(size(N_pcolor,1)+1,size(N_pcolor,2)+1) = 0;
xl = linspace(0,axisL,size(N_pcolor,2)); % Columns of N_pcolor
yl = linspace(0,axisL,size(N_pcolor,1)); % Rows of N_pcolor

pcolor(xl,yl,N_pcolor);
ax = gca;
ax.ZTick(ax.ZTick < 0) = [];

set(get(gca,'child'),'FaceColor','interp','CDataMode','auto');
colormap jet
view(2)

xlabel(['$\widehat{\mathtt{L}}_',num2str(ka),'/\sigma_{\mathtt{L}_{',num2str(ka),'}}$'])
ylabel(['$\widehat{\mathtt{L}}_',num2str(kb),'/\sigma_{\mathtt{L}_{',num2str(kb),'}}$'])
title(['Joint Distribution of extreme ',...
    '$\widehat{\mathtt{L}}_',num2str(ka),'/\sigma_{\mathtt{L}_{',num2str(ka),'}}$',' \& ',...
    '$\widehat{\mathtt{L}}_',num2str(kb),'/\sigma_{\mathtt{L}_{',num2str(kb),'}}$',' values'])


colorbar % Display colorbar
c = colorbar;
c.Label.String = 'probability';
c.Label.Interpreter = 'latex';

caxis manual

%%% uncomment when you know what ctop should be (max of colorbar from
%%% either NL-DLG or Pt. Reyes/MCS joint pdf) and set above, so that both
%%% pdf's have the same colorbar
% caxis([0 ctop]);
axis([0 axisL 0 axisL])

a = x;
a(x==0)=[];

b = y;
b(y==0)=[];

%% plot Pt.Reyes/ MCS joint PDF

fields = fieldnames(PtRstats);
num = length(PtRstats.(fields{ka}));

values = [0 0];

%%% uncomment below if you want wave indices
% valuesOUTp = [0 0 0];

%%% randomly choose numTS of Pt. Reyes to compare with
r = randi([1 length(PtRstats.k1(:,1))],numT,1);

for j = 1:numT
    jj = r(j);
    
    %%% if MCS, indP = 2
    %%% if buoy indP = 3
    
    bufferAFTER = round(60/dt);
    bufferBEFORE = round(-10/dt);
    
    diffIND = PtRstats.(fields{ka})(jj,indP)-PtRstats.(fields{kb})(jj,indP);
    
    if (diffIND >= bufferBEFORE) && (diffIND <= bufferAFTER)
        values = [values; PtRstats.(fields{ka})(jj,1) PtRstats.(fields{kb})(jj,1)];
        %%% uncomment below if you want wave indices
%         valuesOUTp = [valuesOUTp; jj PtRstats.(fields{ka})(jj,1) PtRstats.(fields{kb})(jj,1)];

    else
        values = [values; PtRstats.(fields{ka})(jj,1) 0;0 PtRstats.(fields{kb})(jj,1)];
%         valuesOUTp = [valuesOUTp; jj PtRstats.(fields{ka})(jj,1) 0; PtRstats.(fields{kb})(jj,indP) 0 PtRstats.(fields{kb})(jj,1)];
    end
end

values = values(2:end,:);

% valuesOUTp = valuesOUTp(2:end,:);

valuesP1 = values(:,1);
valuesP1(valuesP1==0)=[];

valuesP2 = values(:,2);
valuesP2(valuesP2==0)=[];

subplot(1,3,2)
[N,~] = hist3(values,'Edges',{0:0.25:axisL 0:0.25:axisL}); 
N = N./sum(N(:));

N_pcolor = N';

N_pcolor(size(N_pcolor,1)+1,size(N_pcolor,2)+1) = 0;
xl = linspace(0,axisL,size(N_pcolor,2)); % Columns of N_pcolor
yl = linspace(0,axisL,size(N_pcolor,1)); % Rows of N_pcolor

pcolor(xl,yl,N_pcolor);
ax = gca;
ax.ZTick(ax.ZTick < 0) = [];

view(2)

set(get(gca,'child'),'FaceColor','interp','CDataMode','auto');
colormap jet

xlabel(['$\widehat{\mathtt{L}}_',num2str(ka),'/\sigma_{\mathtt{L}_{',num2str(ka),'}}$'])
ylabel(['$\widehat{\mathtt{L}}_',num2str(kb),'/\sigma_{\mathtt{L}_{',num2str(kb),'}}$'])

colorbar % Display colorbar
caxis manual
% caxis([0 ctop]);
axis([0 axisL 0 axisL])

simTimePtRhr = numT*PtRtime; %

diff = simTimePtRhr/simTimeDLGhr;

disp(strcat('NL-DLG process waves simulation time: ',{' '},num2str(simTimeDLGhr),' hours'))
disp(strcat('Pt. Reyes/ MCS waves simulation time: ',{' '},num2str(simTimePtRhr),' hours'))
disp(strcat('Pt. Reyes/ MCS waves require ',{' '},num2str(diff),' more simulation time than NL-DLG for ',{' '},num2str(numT),' waves'))

%% plot marginal distributions
subplot(1,3,3)

%on y-axis
histogram(b,'Normalization','pdf','DisplayStyle','stairs','LineWidth',2,'orientation','horizontal');
grid on
hold on
histogram(valuesP2,'Normalization','pdf','DisplayStyle','stairs','LineWidth',2,'orientation','horizontal');
title(['Marginal $pdf$''s of ','$\widehat{\mathtt{L}}_',num2str(ka),'/\sigma_{\mathtt{L}_{',num2str(ka),'}}$','\& $\widehat{\mathtt{L}}_',num2str(kb),'/\sigma_{\mathtt{L}_{',num2str(kb),'}}$'])
ylabel(['$\widehat{\mathtt{L}}_',num2str(kb),'/\sigma_{\mathtt{L}_{',num2str(kb),'}}$'])
axis([0 axisL 0 axisL])

%on x-axis
histogram(a,'Normalization','pdf','DisplayStyle','stairs','LineWidth',2);
histogram(valuesP1,'Normalization','pdf','DisplayStyle','stairs','LineWidth',2);
xlabel(strcat('$\widehat{\mathtt{L}}_',num2str(ka),'/\sigma_{\mathtt{L}_{',num2str(ka),'}}$'))

legend(strcat('NL-DLG process $\widehat{\mathtt{L}}_',num2str(kb),'/\sigma_{\mathtt{L}_{',num2str(kb),'}}$'),...
strcat('Pt. Reyes buoy $\widehat{\mathtt{L}}_',num2str(kb),'/\sigma_{\mathtt{L}_{',num2str(kb),'}}$'),...
strcat('NL-DLG process $\widehat{\mathtt{L}}_',num2str(ka),'/\sigma_{\mathtt{L}_{',num2str(ka),'}}$'),...
strcat('Pt. Reyes buoy $\widehat{\mathtt{L}}_',num2str(ka),'/\sigma_{\mathtt{L}_{',num2str(ka),'}}$'))

%% get maxima configuration probabilities, function adjusted here to only consider 2 SP
function Pstats = failureProbINSIDE(DLGstats,ka,kb)

    set(0,'DefaultAxesFontSize',20)
    set(0,'defaulttextinterpreter','latex')
    set(groot, 'defaultAxesTickLabelInterpreter','latex');
    set(groot, 'defaultLegendInterpreter','latex');

    nsim = 1000; %number of DLG TS
    nSP = 2;
    allSP = 1:nSP;

    %%% get number of maxima congfigurations gievn number of SP, n
    [Bn, ~] = Bell(nSP);

    %%% make struct to hold p(config) and p(safety|config) for 6 panels
    field1 = 'pConfig'; value1 = ones(Bn,1); %%% prob of maxima config

    Pstats = struct(field1,value1);
    fieldsP = fieldnames(Pstats);

    %%% get probability of each ordering given n SP (n!)
    pOrder = 1/factorial(nSP);

    %%% matrix to hold p(config.)- col1, and p(safety|config.)- col2, col3,...
    %%% each column holds p(zi), p(zij), ect.
    probHold = ones(Bn,1);

    %%% find time series markers with a value of z1, z2, z3, ... (or any combo of)
    aa = DLGstats.ziHAT(:,(ka+1))>0;
    bb = DLGstats.ziHAT(:,(kb+1))>0;

    ziHOLD = [aa, bb];
    loc = [1 1000; 1001 2000; 2001 3000; 3001 4000; 4001 5000; 5001 6000; 6001 7000; 7001 8000; 8001 9000; 9001 10000];
    loc = [loc(ka,:); loc(kb,:)];

    counter = 1;
    %%% now go through 1-n groups for maxima configurations
    for k = 1:nSP
        list = SetPartition(nSP,k);
        numIN1 = length(list); %number of configurations given the # of groups

        %%% go through all configurations given group number k
        for hh = 1:numIN1
            innerCount = 1;
            configZiHat = ones(1,nSP);

            %%% index through k parts of group
            for g = 1:k
                members = list{hh,1}{1,g};
                numMembers = length(members);

                %%% add these probabilities together
                membersProb = 0;

                %%% to concatenate all ziHAT of same "type" e.g. z123,
                %%% z213, z312 are all the "same"
                ziHOLDconcat = 1;

                for i = 1:numMembers %%% k members of maxima config.
                    range = (loc(members(i),1):loc(members(i),2))'; 
                    part = members(ismember(members,allSP));
                    notPart = allSP(not(ismember(allSP,members)));
                    partMat = ziHOLD(range,part);

                    %%% which time series have all ziHAT in group
                    mult = ones(nsim,1);
                        for yy = 1:numMembers
                            mult = mult .* partMat(:,yy);
                        end

                    %%% minus any ziHAT not part of group
                    if isempty(notPart) == 0
                        notPartMat = ziHOLD(range,notPart);

                        for z = 1:length(notPart)
                            mult = mult - notPartMat(:,z);
                        end    
                    end

                    %%% find time series which satisfy ziHAT condition-
                    %%% 1 or 0
                    haveZiHat1 = mult;
                    haveZiHat1(haveZiHat1<0)=0;

                    membersProb = membersProb + sum(haveZiHat1)/nsim;
                    configZiHat(g) = membersProb;

                    %%% find p(safety|config & design) for ziHAT 

                    %%% find time series which satisfy ziHAT condition-
                    %%% keep time series marker to compare with ff
                    haveZiHat = mult .* DLGstats.ziHAT(range,1);
                    haveZiHat(haveZiHat<0)=0;
                    haveZiHat(all(haveZiHat==0,2),:)=[];

                    %%% concatenate all ziHAT of same "type" 
                    ziHOLDconcat = [ziHOLDconcat; haveZiHat];
                    innerCount = innerCount + 1;
                end

                %%% get rid of original placeholder 1
                ziHOLDconcat = ziHOLDconcat(2:end);

                %%% if no time series fulfill ziHAT criterion, make the
                %%% vector "1"; since all ff>=1000, this will be not be
                %%% associated with any failures
                if isempty(ziHOLDconcat)
                    ziHOLDconcat = 1;
                end 
            end

            %%% multiply (potentially summed) probabilites 1-k 
            pC = 1;

            for yy = 1:nSP
                pC = pC*configZiHat(yy);
            end            

            %%% multiply together probabilities based on group structure
            %%% probabilities not yet conditioned on successful configuration
            probHold(counter,1) = pOrder * pC * factorial(k) * factorial(nSP-k);

            counter = counter + 1;
        end
    end

    pSuccess = sum(probHold(:,1));
    probHold(:,1) = probHold(:,1) / pSuccess;

    %%% probability of maxima configurations
    Pstats.(fieldsP{1}) = probHold; 
end


%% get NL-DLG time series, function adjusted here to only consider 2 SP
function [ffInfo,masterList,numT,chosenInfo] = getNLDLGts(Pstats,DLGstats,ka,kb)

%%% find time series markers with a value of z1, z2, z3, ... (or any combo of)
aaa = DLGstats.ziHAT(:,(ka+1))>0;
bbb = DLGstats.ziHAT(:,(kb+1))>0;

ziHOLD = [aaa, bbb];
loc = [1 1000; 1001 2000; 2001 3000; 3001 4000; 4001 5000; 5001 6000; 6001 7000; 7001 8000; 8001 9000; 9001 10000];
loc = [loc(ka,:); loc(kb,:)];

n = 2;
nsim = 1000; %num of DLG TS for each surrogate process
allSP = 1:n;
[Bn, ~] = Bell(n);

%% Initial struct set-up
%%% create a struct to hold maxima configuration probabilities, then later
%%% hold indices of DLG time series which fit into the configurations
counter = 1;
for k = 1:n
    list = SetPartition(n,k);
    num = length(list); %number of configurations given the # of groups

    %%% go through all configurations given group number k
    for h = 1:num
        configurationNAMEp = '';
        %%% index through k parts of group
        for g = 1:k
            members = list{h,1}{1,g};
            numMembers = length(members);

            %%% put in indices of DLG TS which fit maxima config. criteria
            nameHOLDonP = 'z';
            for ii = 1:numMembers
                nameHOLDonP = strcat(nameHOLDonP,num2str(members(ii)));
            end           

            nameStrP = strcat(nameHOLDonP);
            configurationNAMEp = strcat(configurationNAMEp,nameStrP);
        end
        
        newField = configurationNAMEp;
        newFieldp = strcat('p',configurationNAMEp);
        
        ffInfo.(newField).(newFieldp) = Pstats.pConfig(counter);
        counter = counter + 1;
    end
end

%% another struct for later to hold total probabilities for similar maxima 
% groups in different maxima configs so we don't repeat DLG TS
counter = 1;
for k = 1:n
    list = SetPartition(n,k);
    num = length(list); %number of configurations given the # of groups

    %%% go through all configurations given group number k
    for h = 1:num
        %%% index through k parts of group
        for g = 1:k
            members = list{h,1}{1,g};
            numMembers = length(members);

            %%% put in indices of DLG TS which fit maxima config. criteria
            nameHOLDonP = 'z';
            for ii = 1:numMembers
                nameHOLDonP = strcat(nameHOLDonP,num2str(members(ii)));
            end           

            nameStr44 = strcat('probCount',nameHOLDonP);
            probCount.(nameStr44) = 0;
        end
        counter = counter + 1;
    end
end

%% populate struct with indices of DLG 
fields = fieldnames(ffInfo);
counter = 1;

%%% now go through 1-n groups for maxima configurations
for k = 1:n
    list = SetPartition(n,k);
    num = length(list); %number of configurations given the # of groups

    %%% go through all configurations given group number k
    for h = 1:num
        %%% index through k parts of group
        for g = 1:k
            members = list{h,1}{1,g};
            numMembers = length(members);

            %%% to concatenate all ziHAT of same "type" i.e. z123,
            %%% z213, z312 are all the "same"
            ziHOLDconcat = zeros(1,length(members)+1);
            nameHOLDon = 'z';

            for iii = 1:numMembers % k members of maxima config.   
                range = (loc(members(iii),1):loc(members(iii),2))'; 
                part = members(ismember(members,allSP));
                notPart = allSP(not(ismember(allSP,members)));
                partMat = ziHOLD(range,part);

                %%% which time series have all ziHAT in group
                mult = ones(nsim,1);
                    for y = 1:numMembers
                        mult = mult .* partMat(:,y);
                    end

                %%% minus any ziHAT not part of group
                if isempty(notPart) == 0
                    notPartMat = ziHOLD(range,notPart);

                    for z = 1:length(notPart)
                        mult = mult - notPartMat(:,z);
                    end    
                end

                %%% find time series which satisfy ziHAT condition-
                %%% 1 or 0
                haveZiHat1 = mult;
                haveZiHat1(haveZiHat1<0)=0;

                %%% find p(safety|config & design) for ziHAT 

                %%% find time series which satisfy ziHAT condition-
                %%% keep time series marker to compare with ff
                %%% also keep ziHAT value for when we do histogram later to
                %%% choose TS based on prob of occurrence
    
                haveZiHat = mult .* DLGstats.ziHAT(range,[1,members+1]);
                haveZiHat(haveZiHat<0)=0;
                haveZiHat(all(haveZiHat==0,2),:)=[];

                %%% concatenate all ziHAT of same "type"                 
                ziHOLDconcat = [ziHOLDconcat; haveZiHat];
                nameHOLDon = strcat(nameHOLDon,num2str(members(iii)));
            end

            %%% get rid of original placeholder (first row)
            ziHOLDconcat = ziHOLDconcat(2:end,:);
            nameStr = strcat(nameHOLDon);
            ffInfo.(fields{counter}).(nameStr) = ziHOLDconcat;
            
            %%% put TS into a different struct to use later 
            TSinfo.(strcat('TS',nameHOLDon)) = ziHOLDconcat;
            
            fNamesInside = fieldnames(ffInfo.(fields{counter}));
            pConfigCount = ffInfo.(fields{counter}).(fNamesInside{1});
            
            probCount.(strcat('probCount',nameHOLDon)) = probCount.(strcat('probCount',nameHOLDon)) + pConfigCount;
        end
        counter = counter + 1;
    end
end

TSinfoSave = TSinfo;
%% now find the max number of MCS we can approximate without repeating TS

%%% now get number of MCS we are trying to replicate i.e. what would most-
%%% likely failure distribution look like if we did 'numTS' # of MCS

%%% also want to make sure that for maxima categories that are in more
%%% than 1 config, we don't repeat TS
%%% use struct probCount

count = 1;
innercount = 1;
fieldsPC = fieldnames(probCount);
gMin = zeros(length(fieldsPC),1);

%%% num TS based on maxima configuration probabilities
for k = 1:n
    list = SetPartition(n,k);
    num = length(list); %number of configurations given the # of groups
    for e = 1:num
        for h = 1:k %clusters in maxima configuration
            fieldsIN = fieldnames(ffInfo.(fields{count}));
            str = strcat('probCount',fieldsIN(h+1));
            pc = probCount.(str{:});
            
            if pc == 0
                gMin(n) = 0;
            else
                minimum = 100000; % artifically high for comparison
                val = length(ffInfo.(fields{count}).(fieldsIN{h+1}))/pc;
                    if val < minimum
                        minimum = val;
                    end 
                gMin(innercount) = minimum;
            end
            innercount = innercount + 1;
        end
        count = count + 1;
    end 
end
gMin(all(gMin==0,2),:)=[];


%%% number of MCS we can approximate to satisfy p(config) probabilities
%%% without repeating trials of DLG TS
numT = floor(min(gMin));
%% now get a list of DLG TS for each config which will approximate the
%%% results of "numTS" MCS

%%% use struct TSinfo so we don't repeat DLG TS over different maxima
%%% configurations that share the same maxima group type
masterList = [];

for n = 1:Bn
    fieldsIN = fieldnames(ffInfo.(fields{n}));
    pc = ffInfo.(fields{n}).(fieldsIN{1});
    fracInv = 1;    
    if pc == 0
        %%% move on
    else
        %%% pick DLG TS
        %%% num of TS to choose from each category within a maxima config.
        
        numA = floor(numT*pc/fracInv);
        for k = 1:length(fieldsIN)-1 %1st field holds prob config, next fields hold clusters
           if numA > 1 
            TSname = strcat('TS',fieldsIN{1+k});
            TS = TSinfo.(TSname)(:,1); % DLG TS indices; length(TS) >= num
            ziVal = TSinfo.(TSname)(:,2:end);           
            numZ = size(ziVal,2); % dim of our hist
            orderHist = [];
            
            if numZ == 1
                minVal = min(TSinfo.(TSname)(:,2));
                maxVal = max(TSinfo.(TSname)(:,2));
                edges = {minVal-0.1:0.1:maxVal+0.1};
            else
                minVal = min(TSinfo.(TSname)(:,2));
                maxVal = max(TSinfo.(TSname)(:,2));
                edges = {minVal-0.1:0.1:maxVal+0.1};         
                for ha = 2:numZ
                    minVal = min(TSinfo.(TSname)(:,1+ha));
                    maxVal = max(TSinfo.(TSname)(:,1+ha));
                    edges{end+1} = minVal-0.1:0.1:maxVal+0.1;
                end
                  
            end
           
            [ NN, bin ] = histcnd(ziVal,edges);
            [maxHit, ~] = max(NN(:));

            if size(bin,2) == 1
                bin = [ones(size(bin)) bin];
            end
            
            for m = maxHit:-1:1
                %%% find bins with 'm' number of occurrences
                hits = find(NN == m);

                hitsVec = hits(:);
                if max(hitsVec) > 0
                    %%% get locations of hits
                    if size(bin,2) == 2 
                        [row, col] = ind2sub(size(NN),hits);
                        if size(row,2) > 1
                            row = row';
                        end
                        
                        if  size(col,2) > 1   
                            col = col';
                        end

                        locations = [row col];     
                    else
                        %%% need to account for n-dimensions!
                        add = size(bin,2);
                        mycell = cell(1,add);

                        [mycell{1:add}] = ind2sub(size(NN),hits);
                        rowsCell = size(mycell{1},1);
                        locations = zeros(rowsCell,add);

                        for z = 1:add
                            locations(:,z) = mycell{z};
                        end 
                    end
                    
                    numSpots = size(locations,1);
                    for p = 1:numSpots
                        bin2 = bin - locations(p,:);
                        %%% row indices of TS which fit this bin
                        orderHist = [orderHist; TS(find(all(bin2==0,2)))];
                    end
                else
                    %%% do nothing
                end
            end
            nameSTR1 = strcat('chosen',fieldsIN{1+k});
            ffInfo.(fields{n}).(nameSTR1) = orderHist(1:numA);
            chosenInfo.(fields{n}).(nameSTR1) = orderHist(1:numA);
            masterList = [masterList; orderHist(1:numA)];
            
            %%% we don't want to repeat TS
            TSinfo.(TSname) = TSinfo.(TSname)(numA+1:end,:);
           end
        end   
    end
end

masterList = sort(masterList, 'ascend');


%% function to get histogram counts of n-dim ziHAT time series
    function [ n, bin ] = histcnd( x, edges )
        %HISTCND Histogram count for n dimensional data.
        % N = HISTCND(X,EDGES), for row vectors X, counts the number of values in
        % X that fall between the grid defined by the cell array of EDGES, each
        % of whose element is a vector that contain monotonically non-decreasing
        % values. N is an N-D array each of whose dimension corresponds to
        % LENGTH(EDGES{j}) and each element contains a count of data that falls
        % into the edge.
        %
        % EDGES must have the same length to the number of columns of X.
        % Alternatively, EDGES can be a numeric vector which gives a uniform
        % grid for all dimensions of X.
        % 
        % N(k1,k2,...) will count the vector X(i,:) if for each dimension
        % j = 1,2,..., EDGES{j}(kj) <= X(i,j) < EDGES{j}(kj+1). The last bin will
        % count any values of X that match EDGES(end).  Values outside the values
        % in EDGES are not counted. Use -inf and inf in EDGES to include all
        % non-NaN values.
        % 
        % [N,BIN] = HISTCND(X,EDGES) also returns subscript indices BIN.
        % BIN is zero for out of range values.
        % 
        % Example:
        %     >> X = randn(100,2);          % 100-by-2 row vectors
        %     >> edges = {-2:.4:2,-2:.5:2}; % ranges for each dimension
        %     >> histcnd(X,edges)
        % 
        %     ans =
        % 
        %          0     0     0     1     1     1     0     0     0
        %          0     1     1     2     1     1     0     0     0
        %          1     0     3     4     0     3     0     0     0
        %          0     1     2     1     3     0     1     0     0
        %          0     3     1     4     2     1     3     1     0
        %          1     1     2     3     3     4     1     0     0
        %          0     1     1     2     1     1     4     0     0
        %          0     1     2     2     2     1     0     0     0
        %          1     2     0     3     2     0     0     1     0
        %          0     1     1     0     0     0     0     0     0
        %          0     0     0     0     0     0     0     0     0
        % 
        % Class support for inputs X:
        %    float: double, single
        % 
        % See also histc.
        % Validation
        if ~isnumeric(x)
            error('Input array must be numeric.');
        end
        if ~iscell(edges)
            if isnumeric(edges) && isvector(edges)
                if isempty(x)
                    n = [];
                    bin = [];
                    return;
                end
                tmp = cell(1,size(x,2));
                tmp(:) = {edges};
                edges = tmp;
            else
                error('Edges must be cell array.');
            end
        end

        if isempty(x)
            x = reshape(x,[0 length(edges)]);
        end

        if length(edges)~=size(x,2)
            error('Invalid cell array.');
        end

        % Compute dimension of the output histogram
        dims = cellfun(@(c) length(c), edges(:)');
        if length(dims)==1
            dims = [1 dims];
        end
        % Quantize input along each dimension
        bin = cell(1,size(x,2));
        outlier = false(size(x,1),1);
        for i = 1:size(x,2)
            [tmp,bin{i}] = histc(x(:,i),edges{i});
            outlier = outlier | (bin{i}==0);
        end

        % Remove outlier before computing a linear index
        ind = bin;
        for i = 1:size(x,2)
            ind{i} = ind{i}(~outlier);
        end
        % Compute count of the index
        n = histc(sub2ind(dims,ind{:}),1:prod(dims));
        % Format the output
        n = reshape(n,dims);
        bin = cat(2,bin{:});
    end
end




end

