function DLGstats = DLGstatsPLACE(DLGstatsH,cdfInfo)
%%% function to read in time series constructed by the DLG from surrograte
%%% processes 1, 2, and 3. Code checks is any of z1hat, z2hat, and/or z3hat
%%% exist in the time series 

tic

nsim = 1000;

fields = fieldnames(DLGstatsH);
fieldC = fieldnames(cdfInfo);

for f = 1:6
    for h = 1:nsim
        %%% to see if a value of z_i in TS is more likely a member of
        %%% z_i EVD (i.e. exteme value, record) or of dist of z_i
        %%% conditioned on z_j EVD
        for k = 1:6
            normMAX = DLGstatsH.(fields{1})(h+(f-1)*nsim,k+1);
        
            if k == f %take EVD value at t=0
                DLGstatsH.(fields{1})(h+(f-1)*nsim,k+1) = normMAX;
            else
                CDFpt = cdfInfo.(fieldC{k})(h,k);
                %this is our conditional pdf vs. EVD
                if (normMAX > CDFpt)
                   DLGstatsH.(fields{1})(h+(f-1)*nsim,k+1) = normMAX; 
                else
                   DLGstatsH.(fields{1})(h+(f-1)*nsim,k+1) = 0; 
                end
            end
        end        
    end
end

for g = 1:2
    DLGstatsH.(fields{g})(all(DLGstatsH.(fields{g})==0,2),:)=[];
end
toc
    
DLGstats = DLGstatsH;
     
end
