function DLGstatsH = DLGstatsHOLD(MphiK1,MphiK2,MphiK3,MphiK4,MphiK5,MphiK6,rmsDLG,cdfInfo)
%%% function to read in time series constructed by the DLG from surrograte
%%% processes 1, 2, and 3. Code checks is any of z1hat, z2hat, and/or z3hat
%%% exist in the time series, and whether failure occurs for CS1-6.

tic
nsim = 1000;

%%% [marker z1HATpresent? loc z2HATpresent? loc z3HATpresent? loc]
%%% marker is 'SP''nsim' >> example: SP1, nsim45 >> 1045
%%% if ziHAT present, mark value, if not present, mark as zero
%%% loc is location where ziHAT occurs in a given time series
%%% if no ziHAT occurs, location is marked as zero
%%% all ziHAT values are given in terms of the respective sigma
field1 = 'ziHAT';  value1 = zeros(1,7);

%%% maxVal records the normalized maxValue of all surrogate processses
%%% within the DLG record
%%% [marker z1Max/z1rms z2Max/z2rms z3Max/z3rms ...]
field2 = 'maxVal';          value2 = zeros(1,7);

DLGstatsH = struct(field1,value1,field2,value2);
fields = fieldnames(DLGstatsH);

folders = {'SeaState/30min/z1','SeaState/30min/z2','SeaState/30min/z3',...
    'SeaState/30min/z4','SeaState/30min/z5','SeaState/30min/z6'};

% folders = {'SeaState/30min/z1P','SeaState/30min/z2P','SeaState/30min/z3P',...
%     'SeaState/30min/z4P','SeaState/30min/z5P','SeaState/30min/z6P'};

% folders = {'SeaState/25hr/z1','SeaState/25hr/z2','SeaState/25hr/z3',...
%     'SeaState/25hr/z4','SeaState/25hr/z5','SeaState/25hr/z6'};


aa = 10000;
bb = 20000;
cc = 30000;
dd = 40000;
ee = 50000;
ff = 60000;
gg = 70000;
hh = 80000;
ii = 90000;
jj = 100000;

MARKER = [aa' bb' cc' dd' ee' ff' gg' hh' ii' jj'];

fieldC = fieldnames(cdfInfo);

for f = 1:6
    folder = folders{f};
    for h = 1:nsim
        %do order based on increasing PNE
        hh = cdfInfo.(fieldC{f})(h,7);

        %%% function to read in DLG time series
         zk = zeros(6,701); 
        [~,zk(1,:),zk(2,:),zk(3,:),zk(4,:),zk(5,:),zk(6,:)] = DLGTS(hh,MphiK1,MphiK2,MphiK3,MphiK4,MphiK5,MphiK6,folder);
        
        marker = MARKER(f)+hh;
        %%% mark which time series we're looking at
        %%% marker is 'SP''nsim' >> example: SP1, nsim45 >> 145
        DLGstatsH.(fields{1})(h+(f-1)*nsim,1) = marker;
        
        %%% mark max normalized value of all SP
        DLGstatsH.(fields{2})(h+(f-1)*nsim,1) = marker;

        %%% to see if a value of z_i in TS is more likely a member of
        %%% z_i EVD (i.e. exteme value, record) or of dist of z_i
        %%% conditioned on z_j EVD
        
        
        for k = 1:6
            
            if k == f
                mid = 101;
                normMAX = max(zk(k,:)/rmsDLG(k));
                DLGstatsH.(fields{2})(h+(f-1)*nsim,k+1) = normMAX;
                DLGstatsH.(fields{1})(h+(f-1)*nsim,k+1) = zk(k,mid)/rmsDLG(k);
            else
                normMAX = max(zk(k,:)/rmsDLG(k));
                DLGstatsH.(fields{2})(h+(f-1)*nsim,k+1) = normMAX;
                DLGstatsH.(fields{1})(h+(f-1)*nsim,k+1) = normMAX;
            end
        end        
    end
end

for g = 1:2
    DLGstatsH.(fields{g})(all(DLGstatsH.(fields{g})==0,2),:)=[];
end
toc
    

    function [Z,zk1,zk2,zk3,zk4,zk5,zk6] = DLGTS(k,MphiK1,MphiK2,MphiK3,MphiK4,MphiK5,MphiK6,folder)

        [Char_SeqNo]=generateConsistentCharNumber(k,4);
        temp_filename=fullfile(folder,'Outputs','AWT_outputs',strcat('AWT_Data_Case001_',Char_SeqNo,'.txt'));
        AWTout = load(temp_filename);

        dt = 0.1;
        t = -100*dt:dt:600*dt;
        %%% need to choose length of time
        t = t';
        Z = zeros(size(t));
        zk1 = zeros(size(t));
        zk2 = zeros(size(t));
        zk3 = zeros(size(t));
        zk4 = zeros(size(t));
        zk5 = zeros(size(t));
        zk6 = zeros(size(t));

        
        % Definition of TransferPhase Used in the calculation of TransferFunction.
        %===========================================
        %+res = H*inc*cos(-omega_e*t+TransferPhase)+
        %===========================================
        % When it is from inc to res, use +TransferPhase.
        % If it is the other way around, use -TransferPhase.

        %%% to reconstruct other responses (not what DLG maximized phases for) use:
        %%% selectPhase (AWT(:,6)) - transferPhase (AWT(:,7)) + ShipmoPhase (Mphi)

        %%% to reconstruct eta when the TransferFunction is for a response, use:
        %%% selectPhase (AWT(:,6)) - transferPhase (AWT(:,7)) = wave (select) phase

        for j = 1:length(MphiK1)
            Z = Z + AWTout(j,5).*cos(-AWTout(j,2)*t + AWTout(j,6) - AWTout(j,7));
            zk1 = zk1 + AWTout(j,5).*MphiK1(j,1).*cos(-AWTout(j,2)*t + AWTout(j,6) - AWTout(j,7) + (MphiK1(j,2)));
            zk2 = zk2 + AWTout(j,5).*MphiK2(j,1).*cos(-AWTout(j,2)*t + AWTout(j,6) - AWTout(j,7) + (MphiK2(j,2)));
            zk3 = zk3 + AWTout(j,5).*MphiK3(j,1).*cos(-AWTout(j,2)*t + AWTout(j,6) - AWTout(j,7) + (MphiK3(j,2)));
            zk4 = zk4 + AWTout(j,5).*MphiK4(j,1).*cos(-AWTout(j,2)*t + AWTout(j,6) - AWTout(j,7) + (MphiK4(j,2)));
            zk5 = zk5 + AWTout(j,5).*MphiK5(j,1).*cos(-AWTout(j,2)*t + AWTout(j,6) - AWTout(j,7) + (MphiK5(j,2)));
            zk6 = zk6 + AWTout(j,5).*MphiK6(j,1).*cos(-AWTout(j,2)*t + AWTout(j,6) - AWTout(j,7) + (MphiK6(j,2)));
        end 
    end 
end
