%-------------------
%GENERAL INFORMATION
%-------------------

% 1. Dataset title: Supporting data belonging to publication: 
% "Experimental study of the impact of blade-tip mounted rotors on the X-Rotor vertical-axis wind turbine"

% 2. Authorship: 
    % Name: David Bensason
    % Institution: Delft University of Technology
    % Email: d.y.bensason@tudelft.nl
    % ORCID: 0000-0002-0590-1524

%-------------------
% DESCRIPTION
%-------------------

% This is a README file for an experimental data repository
% on 4TU DOI:  10.4121/0e7bdd8c-6aa5-49ff-9d79-0b39f998aece. The data concerns the
% experimental results presented in the manuscript titled 
% "Experimental study of the impact of blade-tip mounted rotors on the X-Rotor vertical-axis wind turbine". 
% Two zip folders are inlcuded containing .mat files of the flowfield data
% with and without the secondary rotor. The folder containing the cases with
% the secondary rotor are entitled "stitched_flowfields_final.zip". The
% case without is entitled "stitched_flowfields_SR_comp.zip". 

% Furthermore, CAD files for secondary rotor and sleeve attachment to the
% primary rotor are provided in '4TU_CAD_Share.zip' in the form of 3D
% printable .stl files. 

%% Description of "stitched_flowfields_final.zip" SECONDARY ROTOR CASES
%{
This zip folder includes data structures of the stitched flowfield of the
wake behind the secondary rotor. The datafiles are already 
fully stiched following the method explained in the manuscript. 

File naming convention: 
"Phase" is the primary rotor phase at the time of recording
Phase = -15:15:90. The phases start at -15 degrees and extend to 90
degrees. 

"x" is streamwise measurement plane with respect to the origin (taken as
the center of crossbeam of the primary rotor). 
x_-300 = 300mm upstream of the crossbeam
x_-100 = 100mm upstream of the crossbeam
x_0 = 0mm from the crossbeam (at the center of rotor) -> note, this plane
was not measured at Phase_0 due to excessive laser reflection.
x_100 = 100mm downstream of the crossbeam
x_300 = 300mm downstream of the crossbeam

Example file: 
Phase_15_x_300.mat : Measurement at 300mm downstream of the crossbeam at
primary rotor phase-locked position of 15 degrees. 

When loading the mat structure using load('Phase_15_x_300.mat'), it will load
a 3D matrix structure named "concat_data". 
The definition of the entries of this structure is as follows: 
 
concat_data.x; % streamwise coordinate normalized by primary rotor radius R
concat_data.y; % lateral coordinate normalized by primary rotor radius R
concat_data.z; % axial coordinate normalized by primary rotor radius R
concat_data.Ux; % streamwise flow (m/s)
concat_data.Uy; % lateral flow (m/s)
concat_data.Uz; % axial flow (m/s)
concat_data.Vmag; % velocity magnitude (m/s)
concat_data.dvdy; % Lateral velocity gradient -y (1/s)
concat_data.dwdy; % Axial velocity gradient -y (1/s)
concat_data.dwdz; % Axial velocity gradient -z (1/s)
concat_data.dudy; % Streamwise velocity gradient -y (1/s)
concat_data.dudz; % Streamwise velocity gradient -z (1/s)
concat_data.dvdz; % Lateral velocity gradient -z (1/s)
concat_data.Vortx; % Streamwise vorticity (1/s)
concat_data.Vortmag; % Vorticity magnitude (1/s)
concat_data.div; % 2D Divergence (1/s)
concat_data.swirl; % 2D Swirl Strength (1/s^2)
concat_data.AKE; % Average kinetic energy ((m/s)^2)
concat_data.Re_Ryy; % Reynolds stress lateral-lateral ((m/s)^2)
concat_data.Re_Ryz; % Reynolds stress lateral-axial ((m/s)^2)
concat_data.Re_Rxy; % Reynolds stress streamwise-lateral ((m/s)^2)
concat_data.Re_Rzz; % Reynolds stress axial-axial ((m/s)^2)
concat_data.Re_Rxz; % Reynolds stress streamwise-axial ((m/s)^2)
concat_data.Re_Rxx; % Reynolds stress streamwise-streamwise ((m/s)^2)
concat_data.std_Uy; % Standard deviation in lateral velocity (m/s)
concat_data.std_Uz; % Standard deviation in axial velocity (m/s)
concat_data.std_Ux; % Standard deviation in streamwise velocity (m/s)
concat_data.TKE; % Turbulent kinetic energy ((m/s)^2)
concat_data.Unc_mag; % Uncertainty magnitude velocity (m/s)
concat_data.Unc_Ux; % Uncertainty in streamwise velocity (m/s)
concat_data.Unc_Uy; % Uncertainty deviation in lateral velocity (m/s)
concat_data.Unc_Uz; % Uncertainty deviation in axial velocity (m/s)
concat_data.num_vectors; % n

%}

%% Description of "stitched_flowfields_SR_comp.zip" Without SECONDARY ROTOR
%{
The cases without the secondary rotor as saved in the zipped folder called
"" and follow the same naming convention as described above. When loading
the mat file, for example with load('Phase_90_x_-100.mat'), the structure
"concat_data" will open, with the following entries. 

concat_data.x; % streamwise coordinate normalized by primary rotor radius R
concat_data.y; % lateral coordinate normalized by primary rotor radius R
concat_data.z; % axial coordinate normalized by primary rotor radius R
concat_data.Ux; % streamwise flow (m/s)
concat_data.Uy; % lateral flow (m/s)
concat_data.Uz; % axial flow (m/s)
concat_data.Umag; % velocity magnitude (m/s)
concat_data.dvdy; % Lateral velocity gradient -y (1/s)
concat_data.dvdz; % Lateral velocity gradient -z (1/s)
concat_data.dwdy; % Axial velocity gradient -y (1/s)
concat_data.dwdz; % Axial velocity gradient -z (1/s)
concat_data.dudy; % Streamwise velocity gradient -y (1/s)
concat_data.dudz; % Streamwise velocity gradient -z (1/s)
concat_data.Vortx; % Streamwise vorticity (1/s)
concat_data.Vortmag; % Vorticity magnitude (1/s)
concat_data.div; % 2D Divergence (1/s)
concat_data.swirl; % 2D Swirl Strength (1/s^2)
concat_data.AKE; % Average kinetic energy ((m/s)^2)
concat_data.num_vec; % n
concat_data.Re_Rxx; % Reynolds stress streamwise-streamwise ((m/s)^2)
concat_data.Re_Rxy; % Reynolds stress streamwise-lateral ((m/s)^2)
concat_data.Re_Rxz; % Reynolds stress streamwise-axial ((m/s)^2)
concat_data.Re_Ryy; % Reynolds stress lateral-lateral ((m/s)^2)
concat_data.Re_Ryz; % Reynolds stress lateral-axial ((m/s)^2)
concat_data.Re_Rzz; % Reynolds stress axial-axial ((m/s)^2)
concat_data.std_Ux; % Standard deviation in streamwise velocity (m/s)
concat_data.std_Uy; % Standard deviation in lateral velocity (m/s)
concat_data.std_Uz; % Standard deviation in axial velocity (m/s)
concat_data.TKE; % Turbulent kinetic energy ((m/s)^2)
concat_data.Turbulent_shear_stress; % Turbulent shear stress ((m/s)^2)
%}

%% Description of '4TU_CAD_Share.zip'
%{
This zip folder contains part .stl files of the geometries of the 3D
printed secondary rotor and sleeve used to connect to the primary rotor.

Secondary_Rotor.stl = secondary rotor geometry 
Secondary_Rotor_Sleeve.stl = sleeve connection geometry 

%}

