library(ggplot2)

print_plot_all_demographics <- function(dataset){
  plot_age_histogram(dataset)
  print_demographics(dataset)
  print_experience(dataset)
  print_familiar(dataset)
}

create_participants_in_groups <- function(participants_set, groups){
  participants_in_group <- subset(participants_set, participants_set$quiz_version %in% groups) 
  return(participants_in_group)
}

plot_age_histogram <- function(dataset){
  participants_control <- create_participants_in_groups(participants_anonymized, 
                                                        c("A", "B", "C", "D", "I", "J", "K", "L")) #control
  participants_exp_female <- create_participants_in_groups(participants_anonymized, c("E", "G", "M", "O")) 
  participants_exp_male <- create_participants_in_groups(participants_anonymized, c("F", "H", "N", "P")) 
  
  ages_combined <- data.frame(table(participants_control$age), table(participants_exp_female$age), table(participants_exp_male$age))
  
  ages <- rep(c(7,8,9,10,11,12,13,14,15,16,17,18),3)
  group <-c(rep("Control",12), rep("Experiment - female programmer",12), rep("Experiment - male programmer",12))
  frequenty <- c(29, 20, 33, 42, 30, 29,  9,  8,  4,  2,  NA, 2, ages_combined$Freq.1, NA, ages_combined$Freq.2, NA)
  
  data <- data.frame(ages,group,frequenty)
  
  ageHistogram <- ggplot(data, aes(fill=group, y=frequenty, x=ages)) + 
    geom_bar(position="stack", stat="identity") +
    scale_fill_manual(values = c("#d81b60","#ffc107", "#004d40")) +
    scale_x_continuous(breaks = seq(7, 18, 1)) +
    geom_text(aes(label=frequenty), position = position_stack(vjust= 0.5),
              colour = "white", size = 14) +
    theme(legend.position = "top") +
    guides(fill=guide_legend(title="Groups: ")) +
    xlab("Ages") +
    ylab("Number of participants") +
    theme(text = element_text(size = 18), axis.title = element_text(size = 24), axis.text = element_text(size = 20))
  
  plot(ageHistogram)
  ggsave('plot.png', ageHistogram, width = 10, height = 10)
}

print_demographics<- function(dataset){
  # gender
  print(table(dataset$gender))
  
  #age
  print(table(dataset$age))
  print('mean age')
  print(mean(dataset$age, na.rm = TRUE))
  print('median age')
  print(median(dataset$age, na.rm = TRUE))
  
  #country of bird parents
  # Country of bird parents
  amount_country_parent_origin  <- table(dataset$ethnicity)
  amount_eth_NL_only <- sum(dataset$ethnicity == '{Nederland}', na.rm=TRUE)
  amount_eth_NL_at_least_one <- sum(grep('Nederland', dataset$ethnicity), na.rm=TRUE)
  amount_eth_unknown <- sum(dataset$ethnicity =='{Weet ik niet of zeg ik liever niet}', na.rm=TRUE)
  amount_eth_NL_combo <- sum(dataset$ethnicity == '{Nederland,Marokko}'
                             | dataset$ethnicity == '{Nederland,Indonesië}'
                             | dataset$ethnicity == '{Nederland,Polen}'
                             | dataset$ethnicity == '{Nederland,Suriname}'
                             | dataset$ethnicity == '{Nederland,Duitsland}'
                             | dataset$ethnicity == '{Nederland,Turkije}'
                             | dataset$ethnicity == '{Nederland,Weet ik niet of zeg ik liever niet}'
                             | dataset$ethnicity == '{Geen van bovenstaande, maar een ander land in Europa, Nederland}'
                             | dataset$ethnicity == '{Geen van bovenstaande, maar een ander land buiten Europa, Nederland}'
                             , na.rm=TRUE)
  amount_eth_non_NL <- sum(dataset$ethnicity == '{Marokko, Suriname}'
                           | dataset$ethnicity == '{Indonesië}'
                           | dataset$ethnicity == '{Polen}'
                           | dataset$ethnicity == '{Suriname}'
                           | dataset$ethnicity == '{Duitsland}'
                           | dataset$ethnicity == '{Turkije}'
                           | dataset$ethnicity == '{Marokko}'
                           | dataset$ethnicity == '{Geen van bovenstaande, maar een ander land in Europa}'
                           | dataset$ethnicity == '{Geen van bovenstaande, maar een ander land buiten Europa}'
                           , na.rm=TRUE)
  print('NL only')
  print(amount_eth_NL_only)
  print('At least one')
  print(amount_eth_NL_at_least_one)
  
  #sum(amount_eth_NL_only, amount_eth_unknown, amount_eth_NL_combo, amount_eth_non_NL)
}

print_experience <- function(dataset){
  amount_experience  <- table(dataset$experience)
  amount_experience_no <- sum(dataset$experience == "{Nee}" | grepl("Ik weet niet wat programmeren is", dataset$experience),na.rm = TRUE)
  subset_experience_yes <- subset(dataset, dataset$experience != "{Nee}"
                                  & dataset$experience != "{Ik weet niet wat programmeren is}"
                                  & dataset$experience != "{Nee,Ik weet niet wat programmeren is}"
                                  & dataset$experience != "{Ja, op school,Ik weet niet wat programmeren is}"
                                  & dataset$experience != "{Ja, op school,Nee,Ik weet niet wat programmeren is}"
                                  & dataset$experience != "{Ja, op een activiteit buiten school bijvoorbeeld in de bibliotheek of bij een codeclub,Ja, bij familie, vrienden of thuis,Ik weet niet wat programmeren is}"
                                  & dataset$experience != "{Ja, op school,Ja, op een activiteit buiten school bijvoorbeeld in de bibliotheek of bij een codeclub,Ja, bij familie, vrienden of thuis,Ik weet niet wat programmeren is}"
  )
  amount_experience_yes_school <- sum(grepl("Ja, op school", subset_experience_yes$experience),na.rm = TRUE)
  amount_experience_yes_home <- sum(grepl("Ja, bij familie, vrienden of thuis", subset_experience_yes$experience),na.rm = TRUE)
  amount_experience_yes_activity_outside_school <- sum(grepl("Ja, op een activiteit buiten school bijvoorbeeld in de bibliotheek of bij een codeclub", subset_experience_yes$experience),na.rm = TRUE)
  
  print('no experience incl unknown')
  print(amount_experience_no)
  print('yes')
  print(nrow(subset_experience_yes))
  print('yes,  school')
  print(amount_experience_yes_school)
  print('yes, home')
  print(amount_experience_yes_home)
  print('yes, outside school activity')
  print(amount_experience_yes_activity_outside_school)
}

print_familiar <- function(dataset){
  amount_familiar  <- table(dataset$familiar)
  amount_familiar_no <- sum(dataset$familiar == "{Nee}" | grepl("Weet ik niet", dataset$familiar) ,na.rm = TRUE)
  subset_familiar_yes <- subset(dataset, dataset$familiar != "{Nee}"
                                & dataset$familiar != "{Weet ik niet}"
                                & dataset$familiar != "{Nee,Weet ik niet}"
                                & dataset$familiar != "{Ja, maar ik zie deze persoon niet vaak,Weet ik niet}"
                                & dataset$familiar != "{Ja, iemand die ik vaak zie is programmeur,Ja, van een film, serie of tv,Weet ik niet}"
  )
  amount_familiar_yes_not_often <- sum(grepl("Ja, maar ik zie deze persoon niet vaak", subset_familiar_yes$familiar),na.rm = TRUE)
  amount_familiar_yes_media <- sum(grepl("Ja, van een film, serie of tv", subset_familiar_yes$familiar),na.rm = TRUE)
  amount_familiar_often <- sum(grepl("Ja, iemand die ik vaak zie is programmeur", subset_familiar_yes$familiar),na.rm = TRUE)

  print('not familiar incl unknown')
  print(amount_familiar_no)
  print('yes')
  print(nrow(subset_familiar_yes))
  print('yes,  often')
  print(amount_familiar_often)
  print('yes, not often')
  print(amount_familiar_yes_not_often)
  print('yes, media')
  print(amount_familiar_yes_not_often)
}
