source("functions_demographics.R")

# indicate which files to use
participants_file = "anonymized_participants.csv"
answers_file = "anonymized_answers.csv"

# import anonymized participants and answers
participants_anonymized <- read.csv(participants_file, sep=";")
answers_anonymized <- read.csv(answers_file, sep=";")
answers_anonymized <- answers_anonymized[is.element(answers_anonymized$participant_id, participants_anonymized$id),]

# add age category 1 - 2 -3 
participants_anonymized$age_category <- c(-1)

for(part_id in participants_anonymized$id){
  age <- participants_anonymized[participants_anonymized$id==part_id,]$age
  
  if(age<11){
    participants_anonymized[participants_anonymized$id==part_id,]$age_category <- 1
  } 
  if(age>=11 & age <14){
    participants_anonymized[participants_anonymized$id==part_id,]$age_category <- 2
  } 
  if(age>=14){
    participants_anonymized[participants_anonymized$id==part_id,]$age_category <- 3
  } 
}

remove(age, part_id)

#demographics
participants_anonymized$age <- as.numeric(participants_anonymized$age)
print_plot_all_demographics(participants_anonymized)

# make subsets for IAT
create_participants_in_groups <- function(participants_set, groups){
  participants_anonymized_genderstereotype_control <- subset(participants_set, participants_set$quiz_version %in% groups) 
}

participants_control <- create_participants_in_groups(participants_anonymized, 
                                                      c("A", "B", "C", "D", "I", "J", "K", "L")) #control
participants_control_social <- create_participants_in_groups(participants_anonymized, c("A", "B", "I", "J")) #social control
participants_control_interest <- create_participants_in_groups(participants_anonymized, c("C", "D", "K", "L")) #interest control

answers_control <- answers_anonymized[is.element(answers_anonymized$participant_id, participants_control$id),]

remove(create_participants_in_groups, plot_age_histogram, print_demographics, print_experience, print_familiar, print_plot_all_demographics)
