# -*- coding: utf-8 -*-
"""
Created on Tue May 24 14:04:17 2022

@author: jinglaaynes
"""
import numpy as np
import matplotlib.pyplot as plt
from scipy.signal import argrelextrema, savgol_filter
def default_color_cycle():
    # Back to default color cycle
    new_colors = ['b', '#ff7f0e', '#2ca02c', '#d62728',
                  '#9467bd', '#8c564b', '#e377c2', '#7f7f7f',
                  '#bcbd22', '#17becf']
    plt.rcParams['axes.prop_cycle'] = plt.cycler(color=new_colors)
    return
font = {'family' : 'DejaVu Sans',
        'weight' : 'normal',
        'size'   : '15'}
plt.rc('font', **font)
data=np.loadtxt('M14M16M17M28_OverviewC1.txt')
B, Vbg, Vtg, Vdiff,Vsym, T = data.T
Vbg = np.round(Vbg,1)
Vbgs = np.sort(np.unique(Vbg))
Vbgs = Vbgs[::-1]
Vgfilt = np.multiply(np.round(np.abs(Vbgs), 1) > 1, np.round(Vbgs, 1) > -5) # np.abs
Blist = np.linspace(-3, 3, 499)
Vouttot = np.array([])
plt.figure(figsize=[6.4, 6.5])
for i, Vg in enumerate(Vbgs[Vgfilt]):
    filt = Vbg==Vg
    Bin = B[filt]
    Vin = Vdiff[filt]
    Vout = np.interp(Blist, Bin, Vin)
    Vouttot = np.append(Vouttot, Vout)
    bkgnd = (4-i)*0.5
    plt.plot([-3,3],[bkgnd,bkgnd],'--', c='gray')
    plt.plot(Bin, Vin * 1E7 * 1E-3 + bkgnd, label='$V_\mathrm{}={}$ V'.format('{bg}', Vg))
    peaks = argrelextrema(savgol_filter(Vin,11,1), np.greater)
    #print(Vg)
    #print(Bin[peaks])
#plt.ylim([0, 4000])
plt.xlim([-2.5,2.5])
plt.ylim([-3,2.5])
plt.legend()
plt.xlabel('$B$ (T)', fontsize=20)
plt.ylabel('$R_\mathrm{nl}$ (k$\Omega$)', fontsize=20)
plt.tick_params(direction='in', top=True, right=True)
plt.savefig('BigFocussingPlotM14M16.pdf')
plt.show()
#%% ElectronHoleAsymmetry
ind = [0, 7]
plt.vlines(np.linspace(0.23,1.99,9),-200,600,colors='gray',linestyles='dashed')
for i, Vg in zip(ind, Vbgs[[0,-3]]):
    filt = Vbg==Vg
    if Vg>0:
        Bin = -B[filt]+0.06
    else:
        Bin = B[filt]-0.06
    Vin = Vdiff[filt]
    plt.plot(Bin, Vin*1E7, c='C{}'.format(i), label='$V_\mathrm{}={}$ V'.format('{bg}', Vg))
plt.xlim([0, 2])
plt.ylim([-200,600])
plt.legend()
plt.xlabel('$|B|$ (T)', fontsize=20)
plt.ylabel('$R_\mathrm{nl}$ ($\Omega$)', fontsize=20)
plt.tick_params(direction='in', top=True, right=True)
plt.savefig('ElectronHoleAsymmetry.pdf')
plt.show()
#%% Geom2-ElectronHoleAsymmetry
data = np.loadtxt('M30_BLGhBN14_I12to28_100nA_V14to17_100x.dat', skiprows=26)
data1 = np.loadtxt('M31_BLGhBN14_I12to28_100nA_V14to17_100x.dat', skiprows=26)
data = np.vstack((data, data1))
B, Vbg, Vtg, Vdiff, *other = data.T
Vbgs = np.unique(Vbg)
ind = [0, 7]
for i, Vg in zip(ind, Vbgs[[-1, 1]]):
    filt = Vbg==Vg
    if Vg<0:
        Bin = -B[filt][int(np.sum(filt)/2):]+0.05
    else:
        Bin = B[filt][int(np.sum(filt)/2):]-0.05
    Vin = Vdiff[filt][int(np.sum(filt)/2):]
    plt.plot(Bin, Vin*1E7, c='C{}'.format(i), label='$V_\mathrm{}={}$ V'.format('{bg}', np.round(Vg)))
plt.xlim([0, 2.5])
plt.legend()
plt.xlabel('$|B|$ (T)', fontsize=20)
plt.ylabel('$R_\mathrm{nl}$ ($\Omega$)', fontsize=20)
plt.tick_params(direction='in', top=True, right=True)
plt.savefig('Geom2ElectronHoleAsymmetry.pdf')
plt.show()
#%% Geom3-ElectronHoleAsymmetry
data = np.loadtxt('M32_BLGhBN14_I03to06_100nA_V02to32_100x.dat', skiprows=26)
B, Vbg, Vtg, Vdiff, *other = data.T
Vbgs = np.unique(Vbg)
ind = [0, 7]
plt.figure(figsize=(2.75,4))
for i, Vg in zip(ind, Vbgs[[-1, 1]]):
    filt = Vbg==Vg
    if Vg<0:
        Bin = -B[filt][int(np.sum(filt)/2):]+0.05
    else:
        Bin = B[filt][int(np.sum(filt)/2):]-0.05
    Vin = Vdiff[filt][int(np.sum(filt)/2):]
    plt.plot(Bin, Vin*1E7, c='C{}'.format(i), label='$V_\mathrm{}={}$ V'.format('{bg}', np.round(Vg)))
plt.xlim([0, 1.5])
plt.ylim([-75, 250])
plt.xticks([0,0.5,1,1.5])
plt.legend()
plt.xlabel('$|B|$ (T)', fontsize=20)
plt.ylabel('$R_\mathrm{nl}$ ($\Omega$)', fontsize=20)
plt.tick_params(direction='in', top=True, right=True)
plt.savefig('Geom3ElectronHoleAsymmetry.pdf')
plt.show()
#%% Geom4-ElectronHoleAsymmetry
data = np.loadtxt('M42_BLGhBN14_I32to27_100nA_V02to31_100x.dat', skiprows=26)
B, Vbg, Vtg, Vdiff, *other = data.T
Vbgs = np.unique(Vbg)
ind = [0, 7]
plt.figure(figsize=(2.75,4))
for i, Vg in zip(ind, Vbgs[[-1, 1]]):
    filt = Vbg==Vg
    if Vg<0:
        Bin = -B[filt][int(np.sum(filt)/2):]+0.05
    else:
        Bin = B[filt][int(np.sum(filt)/2):]-0.05
    Vin = Vdiff[filt][int(np.sum(filt)/2):]
    plt.plot(Bin, Vin*1E7, c='C{}'.format(i), label='$V_\mathrm{}={}$ V'.format('{bg}', np.round(Vg)))
plt.xlim([0, 1.5])
plt.ylim([-75, 250])
plt.xticks([0,0.5,1,1.5])
plt.legend()
plt.xlabel('$|B|$ (T)', fontsize=20)
plt.ylabel('$R_\mathrm{nl}$ ($\Omega$)', fontsize=20)
plt.tick_params(direction='in', top=True, right=True)
plt.savefig('Geom4ElectronHoleAsymmetry.pdf')
plt.show()