import pandas as pd
import biogeme.database as db
import biogeme.biogeme as bio
import biogeme.models as models
import biogeme.version as ver
from biogeme.expressions import Beta, Variable

# Load data
datafile = pd.read_csv('Survey_data_Formatted.dat',sep='\t')
database = db.Database('Survey_data_Formatted',datafile)


globals().update(database.variables)

# Parameters to be estimated
ASC_TRAIN = Beta('ASC_TRAIN',0,-1000,1000,0)
ASC_PLANE = Beta('ASC_PLANE',0,-1000,1000,0)
ASC_OPTOUT = Beta('ASC_OPTOUT',0,-1000,1000,1)
B_COST = Beta('B_COST',0,-1000,1000,0)
B_CO2 = Beta('B_CO2',0,-1000,1000,0)
B_TIME_PLANE = Beta('B_TIME_PLANE',0,-1000,1000,0)
B_TIME_TRAIN = Beta('B_TIME_TRAIN',0,-1000,1000,0)

one =  1

# Utilities, including access and egress times in TT
V1 = ASC_TRAIN + B_TIME_TRAIN * (TRAIN_TT + 0.5) + B_COST * TRAIN_TC + B_CO2 * TRAIN_CO2
V2 = ASC_PLANE + B_TIME_PLANE * (PLANE_TT + 2.75) + B_COST * PLANE_TC + B_CO2 * PLANE_CO2
V3 = ASC_OPTOUT

V = {0: V1, 1: V2, 2: V3}

av = {0: one, 1: one, 2: AVAIL_OPTOUT}

logprob = models.loglogit(V,av,CHOICE)

# Call Biogeme
biogeme = bio.BIOGEME(database,logprob)

biogeme.modelName = 'MNL_model'

results = biogeme.estimate()

print(results)

print(results.getEstimatedParameters())
	
pandasCorrelations = results.getCorrelationResults()
